/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.StamenTileSource;

public class Demo
extends JFrame {
    private static final long serialVersionUID = 1L;

    public Demo() {
        super("JMapViewer Demo");
        JComboBox<TileLoader> tileLoaderSelector;
        this.setSize(400, 400);
        final JMapViewer map = new JMapViewer(new MemoryTileCache(), 4);
        this.setLayout(new BorderLayout());
        this.setExtendedState(6);
        JPanel panel = new JPanel();
        JPanel helpPanel = new JPanel();
        this.add((Component)panel, "North");
        this.add((Component)helpPanel, "South");
        JLabel helpLabel = new JLabel("Use right mouse button to move the map,\n left double click or mouse wheel to zoom.");
        helpPanel.add(helpLabel);
        JButton button = new JButton("setDisplayToFitMapMarkers");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.setDisplayToFitMapMarkers();
            }
        });
        JComboBox<TileSource> tileSourceSelector = new JComboBox<TileSource>(new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.MapnikBw(), new OsmTileSource.MapToolKitTopo(), new OsmTileSource.Waze(), new MapQuestTileSource(), new MapQuestAerialTileSource(), new BingAerialTileSource(), new StamenTileSource.Toner(), new StamenTileSource.Terrain(), new StamenTileSource.WaterColor(), new OsmTileSource.MapnikGerman(), new OsmTileSource.Wanderreitkarte(), new OsmTileSource.MapBox(), new OsmTileSource.Esri(), new OsmTileSource.EsriTopo(), new OsmTileSource.Nps(), new OsmTileSource.Apple(), new OsmTileSource.Skobbler(), new OsmTileSource.CloudMade("2"), new OsmTileSource.CloudMade("999"), new OsmTileSource.CloudMade("998"), new OsmTileSource.CloudMade("7"), new OsmTileSource.CloudMade("1960"), new OsmTileSource.CloudMade("1155"), new OsmTileSource.CloudMade("12284"), new OsmTileSource.HillShade(), new OsmTileSource.CycleMap(), new OsmTileSource.BBBikeGerman(), new OsmTileSource.BBBike(), new OsmTileSource.PublicTransport(), new OsmTileSource.Transport()});
        tileSourceSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                map.setTileSource((TileSource)e.getItem());
            }
        });
        try {
            tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmFileCacheTileLoader(map), new OsmTileLoader(map)});
        }
        catch (IOException e) {
            tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmTileLoader(map)});
        }
        tileLoaderSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                map.setTileLoader((TileLoader)e.getItem());
            }
        });
        map.setTileLoader((TileLoader)tileLoaderSelector.getSelectedItem());
        panel.add(tileSourceSelector);
        panel.add(tileLoaderSelector);
        final JCheckBox showMapMarker = new JCheckBox("Map markers visible");
        showMapMarker.setSelected(map.getMapMarkersVisible());
        showMapMarker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.setMapMarkerVisible(showMapMarker.isSelected());
            }
        });
        panel.add(showMapMarker);
        final JCheckBox showTileGrid = new JCheckBox("Tile grid visible");
        showTileGrid.setSelected(map.isTileGridVisible());
        showTileGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.setTileGridVisible(showTileGrid.isSelected());
            }
        });
        panel.add(showTileGrid);
        final JCheckBox showZoomControls = new JCheckBox("Show zoom controls");
        showZoomControls.setSelected(map.getZoomContolsVisible());
        showZoomControls.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                map.setZoomContolsVisible(showZoomControls.isSelected());
            }
        });
        panel.add(showZoomControls);
        panel.add(button);
        final JTextField posField = new JTextField(30);
        helpPanel.add(posField);
        new DefaultMapController(map){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                posField.setText(this.map.getToolTipText(e));
            }
        };
        this.add((Component)map, "Center");
    }

    public static void main(String[] args) {
        new Demo().setVisible(true);
    }
}

