% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.r
\name{indexDDI}
\alias{indexDDI}
\title{Dispersion of dependency index (DDI)}
\usage{
indexDDI(x, ds)
}
\arguments{
\item{x}{A \code{repgrid} object with \code{0}/\code{1} ratings only, where \code{1} indicates a dependency.}

\item{ds}{Predetermined size of sample of dependencies.}
}
\description{
Measures the degree of dispersion of dependency in a situation-resource grid (dependency grid), i.e. the degree to
which a person dispersed critical situations over resource persons (Walker et al., 1988, p. 66). The index is a
renamed adoption of the \verb{diversity index} from the field of ecology where it is used to measure the diversity of
species in a sample. Both are computationally identical. The index is applicable to dependency grids (e.g.,
situation-resource) only, i.e., all grid ratings must be \code{0} or \code{1}.
}
\details{
\emph{Caveat}: The DDI depends on the chosen sample size \code{ds}. Also, its measurement range is not normalized between \code{0} and \code{1},
allowing only comparison between similarly sized grids (see Bell, 2001).

\strong{Theoretical Background}:  \emph{Dispersion of Dependency}: Kelly (1969) proposed that it is problematic to view people
as either \emph{independent} or \emph{dependent} because everyone is, to greater or lesser degrees, dependent upon others in
life. What Kelly felt was important was how well people disperse their dependencies across different people. Whereas
young children tend to have their dependencies concentrated on a  small number of people (typically parents), adults
are more likely to spread their dependencies across a variety of others. Dispersing one's dependencies is generally
considered more psychologically adjusted for adults (Walker et al., 1988).
}
\examples{
# sample grid from Walker et al. (1988), p. 67
file <- system.file("extdata", "dep_grid_walker_1988_2.xlsx" , package = "OpenRepGrid")
x <- importExcel(file)

indexDDI(x, ds = 2:5) 

# using named vector
ds = c("2"=2, "3"=3, "4"=4, "5"=5)  
indexDDI(x, ds)
}
\references{
Bell, R. C. (2001). Some new Measures of the Dispersion of Dependency in a Situation-Resource Grid.
\emph{Journal of Constructivist Psychology, 14}(3), 227-234, \doi{doi:10.1080/713840106}.

Kelly, G. A. (1962). In whom confide: On whom depend for what. In Maher, B. (Ed.). \emph{Clinical psychology and
personality: The selected papers of George Kelly}, 189-206. New York Krieger.

Walker, B. M., Ramsey, F. L., & Bell, R. (1988). Dispersed and Undispersed Dependency.
\emph{International Journal of Personal Construct Psychology, 1}(1), 63-80, \doi{doi:10.1080/10720538808412765}.
}
\seealso{
\link{indexUncertainty}
}
