% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bertin.r
\name{bertinCluster}
\alias{bertinCluster}
\title{Bertin display with corresponding cluster analysis.}
\usage{
bertinCluster(
  x,
  dmethod = c("euclidean", "euclidean"),
  cmethod = c("ward", "ward"),
  p = c(2, 2),
  align = TRUE,
  trim = NA,
  type = c("triangle"),
  xsegs = c(0, 0.2, 0.7, 0.9, 1),
  ysegs = c(0, 0.1, 0.7, 1),
  x.off = 0.01,
  y.off = 0.01,
  cex.axis = 0.6,
  col.axis = grey(0.4),
  draw.axis = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{dmethod}{The distance measure to be used. This must be one of 
\code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, 
\code{"canberra"}, \code{"binary"}, or \code{"minkowski"}.
Default is \code{"euclidean"}.
Any unambiguous substring can be given (e.g. \code{"euc"} 
for \code{"euclidean"}). 
A vector of length two can be passed if a different distance measure for
constructs and elements is wanted (e.g.\code{c("euclidean", "manhattan")}).
This will apply euclidean distance to the constructs and
manhattan distance to the elements.
For additional information on the different types see
\code{?dist}.}

\item{cmethod}{The agglomeration method to be used. This should be (an
unambiguous abbreviation of) one of \code{"ward"}, 
\code{"single"}, \code{"complete"}, \code{"average"}, 
\code{"mcquitty"}, \code{"median"} or \code{"centroid"}.
Default is \code{"ward"}.
A vector of length two can be passed if a different cluster method for
constructs and elements is wanted (e.g.\code{c("ward", "euclidean")}).
This will apply ward clustering to the constructs and
single linkage clustering to the elements. If only one of either
constructs or elements is to be clustered the value \code{NA}
can be supplied. E.g. to cluster elements only use \code{c(NA, "ward")}.}

\item{p}{The power of the Minkowski distance, in case \code{"minkowski"}
is used as argument for \code{dmethod}. \code{p} can be a vector
of length two if different powers are wanted for constructs and
elements respectively (e.g. \code{c(2,1)}).}

\item{align}{Whether the constructs should be aligned before clustering
(default is \code{TRUE}). If not, the grid matrix is clustered 
as is. See Details section in function \code{\link{cluster}} for more information.}

\item{trim}{The number of characters a construct is trimmed to (default is
\code{10}). If \code{NA} no trimming is done. Trimming
simply saves space when displaying the output.}

\item{type}{Type of dendrogram. Either or \code{"triangle"} (default) 
or \code{"rectangle"} form.}

\item{xsegs}{Numeric vector of normal device coordinates (ndc i.e. 0 to 1) to mark
the widths of the regions for the left labels, for the
bertin display, for the right labels and for the 
vertical dendrogram (i.e. for the constructs).}

\item{ysegs}{Numeric vector of normal device coordinates (ndc i.e. 0 to 1) to mark
the heights of the regions for the horizontal dendrogram 
(i.e. for the elements), for the bertin display and for 
the element names.}

\item{x.off}{Horizontal offset between construct labels and construct dendrogram and 
(default is \code{0.01} in normal device coordinates).}

\item{y.off}{Vertical offset between bertin display and element dendrogram and 
(default is \code{0.01} in normal device coordinates).}

\item{cex.axis}{\code{cex} for axis labels, default is \code{.6}.}

\item{col.axis}{Color for axis and axis labels, default is \code{grey(.4)}.}

\item{draw.axis}{Whether to draw axis showing the distance metric for the dendrograms 
(default is \code{TRUE}).}

\item{...}{additional parameters to be passed to function \code{\link{bertin}}.}
}
\value{
A list of two \code{\link{hclust}} object, for elements and constructs
                   respectively.
}
\description{
Element columns and 
constructs rows are ordered according to cluster criterion. Various 
distance measures as well as cluster methods are supported.
}
\examples{
\dontrun{

   # default is euclidean distance and ward clustering 
   bertinCluster(bell2010)                                     

   ### applying different distance measures and cluster methods

   # euclidean distance and single linkage clustering 
   bertinCluster(bell2010, cmethod="single")
   # manhattan distance and single linkage clustering             
   bertinCluster(bell2010, dmethod="manhattan", cm="single") 
   # minkowksi distance with power of 2 = euclidean distance  
   bertinCluster(bell2010, dm="mink", p=2)                     

   ### using different methods for constructs and elements

   # ward clustering for constructs, single linkage for elements
   bertinCluster(bell2010, cmethod=c("ward", "single"))        
   # euclidean distance measure for constructs, manhatten 
   # distance for elements
   bertinCluster(bell2010, dmethod=c("euclidean", "man"))
   # minkowski metric with different powers for constructs and elements    
   bertinCluster(bell2010, dmethod="mink", p=c(2,1)))          

   ### clustering either constructs or elements only
   # euclidean distance and ward clustering for constructs no 
   # clustering for elements
   bertinCluster(bell2010, cmethod=c("ward", NA))  
   # euclidean distance and single linkage clustering for elements 
   # no clustering for constructs            
   bertinCluster(bell2010, cm=c(NA, "single"))                 

   ### changing the appearance
   # different dendrogram type        
   bertinCluster(bell2010, type="rectangle")  
   # no axis drawn for dendrogram                 
   bertinCluster(bell2010, draw.axis=F)                        

   ### passing on arguments to bertin function via ...
    # grey cell borders in bertin display
   bertinCluster(bell2010, border="grey")  
   # omit printing of grid scores, i.e. colors only                  
   bertinCluster(bell2010, showvalues=FALSE)                   

   ### changing the layout
   # making the vertical dendrogram bigger
   bertinCluster(bell2010, xsegs=c(0, .2, .5, .7, 1))
   # making the horizontal dendrogram bigger          
   bertinCluster(bell2010, ysegs=c(0, .3, .8, 1))              
}

}
\seealso{
\code{\link{cluster}}
}
