% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxPredict.R
\name{predict.MxModel}
\alias{predict.MxModel}
\title{\code{predict} method for \code{MxModel} objects}
\usage{
\method{predict}{MxModel}(
  object,
  newdata = NULL,
  interval = c("none", "confidence", "prediction"),
  method = c("ML", "WeightedML", "Regression", "Kalman"),
  level = 0.95,
  type = c("latent", "observed"),
  ...
)
}
\arguments{
\item{object}{an MxModel object from which predictions are desired}

\item{newdata}{an optional \code{data.frame} object. See details.}

\item{interval}{character indicating what kind of intervals are desired.  'none' gives no intervals, 'confidence', gives confidence intervals, 'prediction' gives prediction intervals.}

\item{method}{character the method used to create the predictions.  See details.}

\item{level}{the confidence or predictions level, ignored if not using intervals}

\item{type}{character the type of thing you want predicted: latent variables or manifest variables.}

\item{...}{further named arguments}
}
\description{
\code{predict} method for \code{MxModel} objects
}
\details{
The \code{newdata} argument is either a \code{data.frame} or \code{MxData} object.  In the latter case is replaces the data in the top level model.  In the former case, it is passed as the \code{observed} argument of \code{mxData} with \code{type='raw'} and must accept the same further arguments as the data in the model passed in the \code{object} argument.

The available methods for prediction are 'ML', 'WeightedML', 'Regression', and 'Kalman'.  See the help page for \code{\link{mxFactorScores}} for details on the first three of these.  The 'Kalman' method uses the Kalman filter to create predictions for state space models.
}
