% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLRun_Class.R
\name{makeOMLRun}
\alias{makeOMLRun}
\alias{OMLRun}
\title{Construct OMLRun.}
\usage{
makeOMLRun(run.id = NA_integer_, uploader = NA_integer_,
  uploader.name = NA_character_, task.id, task.type = NA_character_,
  task.evaluation.measure = NA_character_, flow.id = NA_integer_,
  flow.name = NA_character_, setup.id = NA_integer_,
  setup.string = NA_character_, error.message = NA_character_,
  parameter.setting = list(), tags = NA_character_,
  predictions = NULL, input.data = makeOMLIOData(),
  output.data = makeOMLIOData())
}
\arguments{
\item{run.id}{[\code{numeric(1)}]\cr
ID of the run. Added by server. Ignored when uploading a run.}

\item{uploader}{[\code{numeric(1)}]\cr
ID of the user that uploaded the run. Added by server. Ignored when uploading a run.}

\item{uploader.name}{[\code{character(1)}]\cr
Name of the user that uploaded the run. Ignored when uploading a run.}

\item{task.id}{[\code{numeric(1)}]\cr
ID of the task that is solved in this run. This ID is given in the task description.}

\item{task.type}{[\code{character(1)}]\cr
Task type of the run. See \code{\link{listOMLTaskTypes}} for all possible types.}

\item{task.evaluation.measure}{[\code{character(1)}]\cr
Evaluation measure used in the run.}

\item{flow.id}{[\code{character(1)}]\cr
ID of the flow used to solve the task. Returned by the API when you upload the
flow, or given in the flow description when you download an existing flow.}

\item{flow.name}{[\code{character(1)}]\cr
Name of the flow.}

\item{setup.id}{[\code{numeric(1)}]\cr
Unique ID of the used setup. Ignored when uploading a run (i.e., it will be
searched based on the parameter settings).}

\item{setup.string}{[\code{character(1)}]\cr
The CLI string that can invoke the learner with the correct parameter settings.
This argument is optional.}

\item{error.message}{[\code{character(1)}]\cr
Whenever an error occurs during the run, this can be reported here.}

\item{parameter.setting}{[\code{list}]\cr
A list of \code{OMLRunParameter}s containing information on the parameter
settings.}

\item{tags}{[\code{character}]\cr
Optional tags describing the run.}

\item{predictions}{[\code{data.frame}]\cr
The predictions of the run.}

\item{input.data}{[\code{\link{OMLIOData}}]\cr
All data that served as input for the run. Added by server. Ignored when uploading.}

\item{output.data}{[\code{\link{OMLIOData}}]\cr
All data that was the output of this run, i.e.,
predictions, evaluation scores. Most of this will be added by the server, but users can also
provide evaluation scores for their own evaluation measures.}
}
\description{
More details about the elements of a \code{OMLRun} can be found in the
\href{https://github.com/openml/OpenML/blob/master/openml_OS/views/pages/api_new/v1/xsd/openml.run.upload.xsd}{XSD scheme}.
}
\seealso{
Other run-related functions: \code{\link{convertOMLMlrRunToBMR}},
  \code{\link{convertOMLRunToBMR}},
  \code{\link{deleteOMLObject}}, \code{\link{getOMLRun}},
  \code{\link{listOMLRuns}},
  \code{\link{makeOMLRunParameter}},
  \code{\link{tagOMLObject}}, \code{\link{uploadOMLRun}}
}
\concept{run-related functions}
