% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{gamma_correction}
\alias{gamma_correction}
\title{Gamma correction}
\usage{
gamma_correction(image, gamma)
}
\arguments{
\item{image}{matrix or 3-dimensional array where the third dimension is equal to 3}

\item{gamma}{a positive value}
}
\value{
depending on the input, either a matrix or an array
}
\description{
Gamma correction
}
\details{
This function applies gamma correction to a matrix or to a 3-dimensional array where the third dimension is equal to 3. The gamma correction controls the overall brightness of an image.
}
\examples{

path = system.file("tmp_images", "2.jpg", package = "OpenImageR")

image = readImage(path)

filt = gamma_correction(image, gamma = 0.5)

}
\author{
Lampros Mouselimis
}
