% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_conditionalPower}
\alias{get_conditionalPower}
\title{Calculates the conditional power.}
\usage{
get_conditionalPower(t, u, enrolled, r1, n1, r, s, n, pc1, pt1,
  sub1 = setupSub1Design())
}
\arguments{
\item{t}{observed responses in the subset endpoint.}

\item{u}{observed responses in the superset endpoint.}

\item{enrolled}{number of patients enrolled so far.}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{r}{critical value for the subset endpoint.}

\item{s}{critical value for the superset endpoint.}

\item{n}{overall sample size.}

\item{pc1}{the response probability under the alternative hypothesis for the subset endpoint.}

\item{pt1}{the response probability under the alternative hypothesis for the superset endpoint.}

\item{sub1}{"sub1"-object used to calculate the p value in c++ .}
}
\description{
Calculates the conditional power of a given subset design.
}
\examples{
\dontrun{
#Setup "sub1"-object
sub1 <- setupSub1Design(pc0 = 0.5, pt0 = 0.6)

#Calculate a  subset design
design <- getSolutionsSub1(sub1, skipN1 = FALSE)$Solutions[4,]

t <- 5
u <- 7
enrolled <- 10

con_p <- get_conditionalPower(t, u, enrolled, design$r1,
design$n1, design$r, design$s, design$n, design$pc1, design$pt1, sub1)
}
}
\seealso{
\code{\link{setupSub1Design}}
}

