% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getSolutionsSub1}
\alias{getSolutionsSub1}
\title{Calculates designs for a given "sub1"-object.}
\usage{
getSolutionsSub1(sub1 = setupSub1Design(), skipS = TRUE, skipR = TRUE,
  skipN1 = TRUE, lowerBorder = 0, upperBorder = 0,
  useCurtailment = FALSE, curtailAll = FALSE, cut = 0,
  replications = 1000)
}
\arguments{
\item{sub1}{a "sub1"-object which will be used to calculate fitting designs}

\item{skipS}{boolean value; skips the iteration over "s" at certian points to improve calculation speed (finds less designs)}

\item{skipR}{boolean value; skips the iteration over "r" at certian points to improve calculation speed (finds less designs)}

\item{skipN1}{boolean value; skips the iteration over "n1" at certian points to improve calculation speed (finds less designs and it is impossible to determine the optimalization criteria of the found designs)}

\item{lowerBorder}{sets a minimal value for "n" (number of patients to be recruited)}

\item{upperBorder}{sets a maximal value for "n" (number of patients to be recruited)}

\item{useCurtailment}{determines if the effect of (non-)stochastic curtailment should also be calculated for the found designs}

\item{curtailAll}{boolean value; if true the effect of (non-)stochastic curtailment will be calculated for different cut points in 0.05 steps starting with the value of the parameter "cut".}

\item{cut}{sets the "cut point" used to calculate the effect of (non-)stochastic curtailment. A study is stopped if the conditional power falls below the value of "cut".}

\item{replications}{number of simulations to estimate the effect of (non-)stochastic curtailment.}
}
\description{
By iterating over all possible values for "r1", "n1", "r", "s" and "n" designs for a given "sub1"-object are found.
Proceeding to the second stage of the study more than "r1" responses among the first "n1" patients in the subset endpoint are needed.
Rejecting the null hypothesis more than "r" responses in the subset endpoint
or more than "s" responses in the superset endpoint among "n" patients are needed.
}
\examples{
\dontrun{
# Example 1: Using the default values
sub1 <- setupSub1Design()
getSolutionsSub1(sub1)

# Example 2: Setting up a "sub1"-object, then calculating designs
sub1 <- setupSub1Design(alpha = 0.1, beta = 0.2, pc0 = 0.3, pt0 = 0.4)
designs <- getSolutionsSub1(sub1)$Solutions
designs

# Example 2: Calculating designs and simulating the influence of stochastic curtailment
# for each design.
sub1 <- setupSub1Design(alpha = 0.1, beta = 0.2, pc0 = 0.3, pt0 = 0.4)
designs <- getSolutionsSub1(sub1, useCurtailment = TRUE, curtailAll = TRUE, cut = 0.3)
#Contains the found designs, the influence of stochastic curtailment
#and the regarding stopping rules .
designs
}
}
\references{
Kunz C.U., Kieser M (2012): Curtailment in single-arm two-stage phase II oncology trials. Biometrical Journal 54, 445-456
}
\seealso{
\code{\link{setupSub1Design}}
}

