% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_ordinalRegression.R
\name{olink_ordinalRegression}
\alias{olink_ordinalRegression}
\title{Function which A two-way ordinal analysis of variance can address an experimental design with two independent variables, each of which is a factor variable.  The main effect of each independent variable can be tested, as well as the effect of the interaction of the two factors.}
\usage{
olink_ordinalRegression(
  df,
  variable,
  covariates = NULL,
  return.covariates = F,
  verbose = T
)
}
\arguments{
\item{df}{NPX or Quantified_value data frame in long format with at least protein name (Assay), OlinkID, UniProt, Panel and a factor with at least 3 levels.}

\item{variable}{Single character value or character array.
Variable(s) to test. If length > 1, the included variable names will be used in crossed analyses .
Also takes ':'/'*' notation.}

\item{covariates}{Single character value or character array. Default: NULL.
Covariates to include. Takes ':'/'*' notation. Crossed analysis will not be inferred from main effects.}

\item{return.covariates}{Logical. Default: False. Returns F-test results for the covariates. Note: Adjusted p-values will be NA for the covariates.}

\item{verbose}{Logical. Default: True. If information about removed samples, factor conversion and final model formula is to be printed to the console.}
}
\value{
A tibble containing the ANOVA results for every protein.
The tibble is arranged by ascending p-values.
}
\description{
Performs an ANOVA F-test for each assay (by OlinkID) in every panel using car::Anova and Type II sum of squares.
The function handles only factor and/or covariates. \cr\cr
Samples that have no variable information or missing factor levels are automatically removed from the analysis (specified in a message if verbose = T).
Character columns in the input dataframe are automatically converted to factors (specified in a message if verbose = T).
Crossed analysis, i.e. A*B formula notation, is inferred from the variable argument in the following cases: \cr
\itemize{
\item c('A','B')
\item c('A: B')
\item c('A: B', 'B') or c('A: B', 'A')
}
Inference is specified in a message if verbose = T. \cr
The formula notation of the final model is specified in a message if verbose = T. \cr\cr
Adjusted p-values are calculated by stats::p.adjust according to the Benjamini & Hochberg (1995) method (“fdr”).
The threshold is determined by logic evaluation of Adjusted_pval < 0.05. Covariates are not included in the p-value adjustment.
}
\examples{
\donttest{
library(dplyr)
npx_df <- npx_data1 \%>\% filter(!grepl('control',SampleID, ignore.case = TRUE))

#Two-way Ordinal Regression with CLM.
#Results in model NPX~Treatment+Time+Treatment:Time.
ordinalRegression_results <- olink_ordinalRegression(df = npx_df,
                             variable="Treatment:Time")}
}
