% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORdensity.R
\docType{methods}
\name{preclusteredData}
\alias{preclusteredData}
\alias{preclusteredData,ORdensity-method}
\title{Preprocessed description of all the identified potential DE genes}
\usage{
preclusteredData(object, verbose = TRUE)

\S4method{preclusteredData}{ORdensity}(object, verbose = TRUE)
}
\arguments{
\item{object}{Object of class \code{\link[=ORdensity-class]{ORdensity}}.}

\item{verbose}{Boolean indicating if log messages are going to be printed.}
}
\value{
\code{\link{data.frame}} with all potential DE genes.
}
\description{
This function returns the description of all the identified 
potential DE genes in terms of variables OR, FP, and dFP in one only table so that 
the interesed user can perform her own clustering analysis.
}
\examples{
# Read data from 2 experimental conditions
simexpr_reduced <- simexpr[c(1:15,101:235),]
x <- simexpr_reduced[, 3:32]
y <- simexpr_reduced[, 33:62]
EXC.1 <- as.matrix(x)
EXC.2 <- as.matrix(y)
myORdensity <- new("ORdensity", Exp_cond_1 = EXC.1, Exp_cond_2 = EXC.2, B = 20)
# dataframe with all potential DE genes:
preclusteredData(myORdensity)
}
