% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarySubcascades.R
\name{summarySubcascades}
\alias{summarySubcascades}
\title{Overview Subcascades}
\usage{
summarySubcascades(subcascades = NULL)
}
\arguments{
\item{subcascades}{A Subcascades object as it is returned by \code{\link{subcascades}}-function.
The Subcascades object is made up of a list of matrices.
Each matrix comprises the evaluation results of cascades of a specific length and
is sorted row-wise according to the achieved minimal classwise sensitivities of the cascades (decreasing).
The rownames show the class order by a character string of type '1>2>3' and the entries the sensitivity for each position of the cascade.}
}
\value{
A matrix summarizing the overview characteristics of the Subcascades object.
For each size (rows) the number of cascades within the Subcascades object (number) and the minimal classwise sensitivity (min.class.sens) are given.
}
\description{
\code{summarySubcascades} returns a summarizing overview. For each length the number of cascades and the minimal class-wise sensitivity is given.
}
\details{
This function gives an overview of the Subcascades object. For each length in
the Subcascades object the number of cascades of that length, as well as their
minimal classwise sensitivity is given.
}
\examples{
library(TunePareto)
data(esl)
data <- esl$data
labels <- esl$labels
foldList <- generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
genMap <- gen.predictionMap(data, labels, foldList = foldList, 
classifier = tunePareto.svm(), kernel='linear')

# use default parameter settings
subcascades <- subcascades(genMap,thresh=0.7)
summarySubcascades(subcascades)
}
\seealso{
\code{\link{plot.Subcascades}}, \code{\link{subcascades}}, \code{\link{summaryGroupwise}}, \code{\link{summaryClasses}}
}
