% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_num_label_repetitions.R
\name{get_num_label_repetitions_each_site}
\alias{get_num_label_repetitions_each_site}
\title{Get the number of trial repetitions for a given label for each site}
\usage{
get_num_label_repetitions_each_site(binned_data, labels, label_levels = NULL)
}
\arguments{
\item{binned_data}{A string that list a path to a file that has data in
binned format, or a data frame of binned_data that is in binned format.}

\item{labels}{A string specifying which label variable should be
used for calculating the minimum number of level repetitions.}

\item{label_levels}{A character vector specifying which levels to include.
If not set, all levels will be used.}
}
\value{
A data frame where each row corresponds to a recording site. The columns
in the data frame are:
\itemize{
\item \emph{siteID}: The siteID each row in the data frame corresponds to
\item \emph{min_repeats}: minimum number of repeats across all label levels
\item \emph{level_XXX}: The number or repeats for a specific label level
\item \emph{site_info.XXX}: The site_info for each site
}
}
\description{
Calculates how many repeated trials there are for each label
level for each site. This can be useful for selecting sites that have a
minimum number of repetitions of each stimulus or other experimental
condition.
}
