% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extintions.R
\name{Mostconnected}
\alias{Mostconnected}
\title{Extinctions analysis from most connected to less conected nodes in the network}
\usage{
Mostconnected(Network)
}
\arguments{
\item{Network}{a trophic network of class network}
}
\value{
exports data frame with the characteristics of the network after every
extintion. The resulting data frame contains 11 columns that incorporate the
topological index, the secondary extinctions, predation release, and total extinctions of the network
in each primary extinction.
}
\description{
It takes a network and it calculates wich node is the most conected
of the network, using total degree. Then remove the most connected node,
and calculates the the topological indexes of the network and the number of
secundary extintions (how many species have indegree 0, without considered
primary producers). After that, remove the nodes that were secondarily extinct
in the previous step and recalculate which is the new most connected
node and so on, until the number of links in the network is zero.
}
\examples{
data("net")
Mostconnected(Network = net)
}
\seealso{
[NetworkExtinction::ExtinctionOrder()]
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>

M.Isidora Avila Thieme <msavila@uc.cl>
}
