% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_wsd.R
\name{nd.wsd}
\alias{nd.wsd}
\title{Distance with Weighted Spectral Distribution}
\usage{
nd.wsd(A, out.dist = TRUE, K = 50, wN = 4)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{K}{the number of bins for the spectrum interval \eqn{[0,2].}}

\item{wN}{a decaying exponent; default is \eqn{4} set by authors.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{spectra}{an \eqn{(N\times M)} matrix of rows being eigenvalues for each graph.}
}
}
\description{
Normalized Laplacian matrix contains topological information of
a corresponding network via its spectrum. \code{nd.wsd} adopts weighted
spectral distribution of eigenvalues and brings about a metric via
binning strategy.
}
\examples{
## generate two types of adjacency matrices of size (3-by-3)
rbin1 = rbinom(9,1,0.8); mat1 = matrix(rbin1,nrow=3)
rbin2 = rbinom(9,1,0.2); mat2 = matrix(rbin2,nrow=3)

mattype1 = ceiling((mat1+t(mat1))/2)
mattype2 = ceiling((mat2+t(mat2))/2)

A = list()
for (i in 1:3){A[[i]]=mattype1} # first 3 are type-1
for (i in 4:6){A[[i]]=mattype2} # next  3 are type-2

## Compute Distance Matrix and Visualize
output = nd.wsd(A, out.dist=FALSE, K=10)
image(output$D, main="two group case")

}
\references{
\insertRef{fay_weighted_2010}{NetworkDistance}
}
