% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_him.R
\name{nd.him}
\alias{nd.him}
\title{HIM Distance}
\usage{
nd.him(A, out.dist = TRUE, xi = 1, ntest = 10)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{xi}{a parameter to control balance between two distances.}

\item{ntest}{the number of searching over \code{\link{nd.csd}} parameter.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
Hamming-Ipsen-Mikhailov (HIM) combines the local Hamming edit distance and the global
Ipsen-Mikhailov distance to merge information at each scale. For Ipsen-Mikhailove distance,
it is provided as \code{nd.csd} in our package for consistency. Given a parameter \eqn{\xi} (\code{xi}),
it is defined as
\deqn{HIM_{\xi}(A,B)=\sqrt{H^2(A,B)+\xi\cdot IM^2(A,B)}/\sqrt{1+\xi}}
where \eqn{H} and \eqn{IM} stand for Hamming and I-M distance, respectively.
}
\examples{
## generate two types of adjacency matrices of size (3-by-3)
rbin1 = rbinom(9,1,0.8); mat1 = matrix(rbin1,nrow=3)
rbin2 = rbinom(9,1,0.2); mat2 = matrix(rbin2,nrow=3)

mattype1 = ceiling((mat1+t(mat1))/2); diag(mattype1)=0;
mattype2 = ceiling((mat2+t(mat2))/2); diag(mattype2)=0;

A = list()
for (i in 1:3){A[[i]]=mattype1} # first 3 are type-1
for (i in 4:6){A[[i]]=mattype2} # next  3 are type-2

## compute distance and visualize
output = nd.him(A, out.dist=FALSE)
image(output$D, main="two group case")

}
\references{
\insertRef{jurman_him_2015}{NetworkDistance}
}
\seealso{
\code{\link{nd.hamming}}, \code{\link{nd.csd}}
}
