% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{uphill}
\alias{uphill}
\alias{uphill,worldMatrix,missing,agentMatrix,numeric-method}
\alias{uphill,worldArray,character,agentMatrix,numeric-method}
\title{Move uphill}
\usage{
uphill(world, pVar, turtles, nNeighbors, torus = FALSE)

\S4method{uphill}{worldMatrix,missing,agentMatrix,numeric}(world, turtles,
  nNeighbors, torus)

\S4method{uphill}{worldArray,character,agentMatrix,numeric}(world, pVar,
  turtles, nNeighbors, torus = FALSE)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{pVar}{Character. If the \code{world} is a worldArray object, \code{pVar}
is the name of the layer to use to define the patches values.
\code{pVar} must not be provided if the \code{world} is a worldMatrix object.}

\item{turtles}{AgentMatrix object representing the moving agents.}

\item{nNeighbors}{Integer: 4 or 8. Represents the number of neighbor patches
considered.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
AgentMatrix representing the \code{turtles} with updated
        coordinates and updated data for their "heading" values and
        previous coordinates "prevX"
        and "prevY".
}
\description{
Move the \code{turtles} to their neighboring patch with the highest value.
}
\details{
If no neighboring patch has a larger value than the patch where the
         turtle is currently located on, the turtle stays on this patch. It still
         moves to the patch center if it was not already on it.

         If there are multiple neighboring patches with the same highest value,
         the turtle chooses one patch randomly.

         If a turtle is located on a patch on the edge
         of the \code{world} and \code{torus = FALSE}, it has fewer
         neighbouring patches as options to move than \code{nNeighbors}; if
         \code{torus = TRUE}, the turtle can move on the other side of the \code{world} to
         move uphill and its choice of neighbouring patches is always equals to
         \code{nNeighbors}.
}
\examples{
w1 <- createWorld(minPxcor = 1, maxPxcor = 10, minPycor = 1, maxPycor = 10,
                          data = runif(100))
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)

t1 <- uphill(world = w1, turtles = t1, nNeighbors = 8)
points(t1, col = of(agents = t1, var = "color"), pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#uphill}
}
\author{
Sarah Bauduin
}
