% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{patchAhead}
\alias{patchAhead}
\alias{patchAhead,worldNLR,agentMatrix,numeric-method}
\title{Patches ahead}
\usage{
patchAhead(world, turtles, dist, torus = FALSE)

\S4method{patchAhead}{worldNLR,agentMatrix,numeric}(world, turtles, dist,
  torus = FALSE)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{turtles}{AgentMatrix object representing the moving agents.}

\item{dist}{Numeric. Vector of distances from the \code{turtles}. \code{dist} must be
of length 1 or of length \code{turtles}.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
Matrix (ncol = 2) with the first column "pxcor" and the second column
        "pycor" representing the coordinates of the patches at the distances \code{dist}
        and \code{turtles}'s headings directions
        of \code{turtles}. The order of the patches follows the order of the \code{turtles}.
}
\description{
Report the coordinates of the patches at the given
distances of the \code{turtles} in the direction of their headings.
}
\details{
If \code{torus = FALSE} and the patch at distance \code{dist} of a turtle
         is outside the \code{world}'s extent, \code{NA}
         are returned for the patch coordinates. If \code{torus = TRUE}, the patch
         coordinates from a wrapped \code{world} are returned.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
patchAhead(world = w1, turtles = t1, dist = 1)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#patch-ahead}
}
\author{
Sarah Bauduin
}
