% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netfacs_extract.R
\name{netfacs.extract}
\alias{netfacs.extract}
\title{Extract results of 'netfacs' function for specific combination sizes
For the selected combination size, the function returns all combinations that had significantly higher probabilities of occuring than expected under the null condition}
\usage{
netfacs.extract(
  netfacs.data,
  level = 1,
  min.count = 1,
  min.prob = 0,
  min.specificity = 0,
  significance = 0.01
)
}
\arguments{
\item{netfacs.data}{object resulting from netfacs() function}

\item{level}{combination size for which all remaining combinations should be extracted}

\item{min.count}{numeric value, suggesting how many times a combination should at least occur to be displayed}

\item{min.prob}{numeric value, suggesting the probability at which a combination should at least occur to be displayed}

\item{min.specificity}{numeric value, suggesting the specificity a combination should at least have for the test condition to be displayed}

\item{significance}{numeric value, determining the p-value below which combinations are considered to be dissimilar enough from the null distribution}
}
\value{
Function returns a dataframe that includes all combinations for the selected combination size that fulfil the selected criteria
}
\description{
Extract results of 'netfacs' function for specific combination sizes
For the selected combination size, the function returns all combinations that had significantly higher probabilities of occuring than expected under the null condition
}
\examples{
### how do angry facial expressions differ from non-angry ones?
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

netfacs.extract(angry.face,
  level = 2,
  min.count = 5,
  min.prob = 0.01,
  min.specificity = 0.5,
  significance = 0.01
)
}
