\name{SimulateTypeA}
\alias{SimulateTypeA}
\title{Simulation of the Generalized Thomas Model of Type A}
\description{
  Simulation of the generalized Thomas model of type A.
}
\usage{
  SimulateTypeA(pars, seed = NULL, plot = TRUE)
}
\arguments{
  \item{pars}{a named vector of containing the values of the model parameters
    (\code{mu}, \code{nu}, \code{a}, \code{sigma1}, \code{sigma2}), where
    \code{mu} is an intensity of parents, \code{nu} is an expected number of
    descendants for each parent, \code{a} is a mixture parameter, \code{sigma1}
    and \code{sigma2} are parameters of the dispersal kernel for each component.}
  \item{seed}{a positive integer, which is the seed for a sequence of uniform
    random numbers. The default seed is based on the current time.}
  \item{plot}{logical. If \code{TRUE} (default), simulated parent points and
    offspring points are plotted.}
}
\details{
  Parents' configuration and numbers of the offspring cluster sizes are
  generated by the same way as the Thomas model.

  Let random variable \eqn{U_k, k=1,2}{Uk, k=1,2} be independently and uniformly
  distributed in [0,1]. Then \eqn{r} satisfies as follows: 

  \deqn{r = \sigma_1 \sqrt{-2 \log(1-U_1)},  \quad U_2 \le a ,}{%
        r = \sigma1 \sqrt{ -2log(1-U1) },  U2 <= a ,}
  \deqn{r = \sigma_2 \sqrt{-2 \log(1-U_1)},  \quad \mathrm{otherwise.}}{%
        r = \sigma2 \sqrt{ -2log(1-U1) }, otherwise.}

  Each of the offspring coordinates \eqn{(x_j^i, y_j^i)} is given like that of
  \code{\link{SimulateIP}}. Using series of different uniform random numbers
  \eqn{\{ U_1, U_2, U \}}{{U1, U2, U}} for different \eqn{i} and \eqn{j}.
}
\value{
  \item{parents}{a list containing two components named "\code{n}" and
    "\code{xy}" giving the number and the matrix of \code{(x,y)} coordinates of
    simulated parents points respectively.}
  \item{offspring}{a list containing two components named "\code{n}" and
    "\code{xy}" giving the number and the matrix of \code{(x,y)} coordinates of
    simulated offspring points respectively.}
}
\references{
  U. Tanaka, Y. Ogata and K. Katsura,
  Simulation and estimation of the Neyman-Scott type spatial cluster models,
  \emph{Computer Science Monographs} \bold{No.34}, 2008, 1-44.
  The Institute of Statistical Mathematics.
}
\examples{
pars <- c(mu = 50.0, nu = 30.0, a = 0.03, sigma1 = 0.005, sigma2 = 0.1)
SimulateTypeA(pars, seed = 575)
}

\keyword{spatial}
