% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvstpdf.R
\name{mvstpdf}
\alias{mvstpdf}
\title{multivariate skew-t  probability density function}
\usage{
mvstpdf(x, xi, sigma, psi, df, Log = TRUE)
}
\arguments{
\item{x}{\code{p x n} data matrix with \code{n} the number of observations and
\code{p} the number of dimensions}

\item{xi}{mean vector or list of mean vectors (either a vector,
a matrix or a list)}

\item{sigma}{variance-covariance matrix or list of variance-covariance
matrices (either a matrix or a list)}

\item{psi}{skew parameter vector or list of skew parameter vectors
(either a vector, a matrix or a list)}

\item{df}{a numeric vector or a list of the degrees of freedom
(either a vector or a list)}

\item{Log}{logical flag for returning the log of the probability density
function. Defaults is \code{TRUE}.}
}
\description{
multivariate skew-t  probability density function
}
\examples{
mvstpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
      xi=c(0, 0), psi=c(1, 1), sigma=diag(2),
      df=100000000, Log=FALSE
)
mvsnpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
      xi=c(0, 0), psi=c(1, 1), sigma=diag(2),
      Log=FALSE
)
mvstpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
      xi=c(0, 0), psi=c(1, 1), sigma=diag(2),
      df=100000000
)
mvsnpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
      xi=c(0, 0), psi=c(1, 1), sigma=diag(2)
)


}
\seealso{
\code{\link{mvtpdf}}, \code{\link{mvsnpdf}}, \code{\link{mmvstpdfC}}, \code{\link{mvstlikC}}
}
