\name{ModelFit}
\alias{ModelFit}

\title{Compute overall model fit statistics for outputs generated by estimation functions in the package}

\description{
  This function computes overall model fit statistics for outputs generated by estimation functions in the package, including \code{\link{ParMLE}} and \code{\link{JMLE}}. The function currently provides the AIC and BIC statistics.
}

\usage{
ModelFit(x)
}

\arguments{
  \item{x}{The output from the function (The list of all outputs).}
}

\value{
  \item{AIC}{The AIC statistic of the overall model. See the reference for details.}
  \item{BIC}{The BIC statistic of the overall model. See the reference for details.}
}

\seealso{
\code{\link{ParMLE}}, \code{\link{JMLE}}
}

\references{
  Chen, J. de la Torre, J., & Zhang, Z. (2013). Relative and absolute fit evaluation in cognitive diagnosis modeling. \emph{Journal of Educational Measurement, 50}, 123-140.
}

\examples{
# See examples in ParMLE and JMLE.
}
