% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCols.R
\name{compareCols}
\alias{compareCols}
\title{Compare elements in lists with aim of combining}
\usage{
compareCols(
  ...,
  keepNames = TRUE,
  testEqual = FALSE,
  diff.only = TRUE,
  fun.class = base::class,
  quiet,
  as.fun = NULL
)
}
\arguments{
\item{...}{objects which element names to compare}

\item{keepNames}{If TRUE, the original dataset names are used in
reported table. If not, generic x1, x2,... are used. The
latter may be preferred for readability.}

\item{testEqual}{Do you just want a TRUE/FALSE to whether the
names of the two objects are the same? Default is FALSE which
means to return an overview for interactive use. You might
want to use TRUE in programming. However, notice that this
check may be overly rigorous. Many classes are compitable
enough (say numeric and integer), at compareCols doesn't take
this into account.}

\item{diff.only}{If TRUE, don't report columns where no difference
found. Default is TRUE if number of data sets supplied is
greater than one. If only one data set is supplied, the full
list of columns is shown by default.}

\item{fun.class}{the function that will be run on each column to
check for differences. base::class is default. Notice that the
alternative base::typeof is different in certain ways. For
instance, typeof will not report a difference on numeric vs
difftime. You could basically submit any function that takes a
vector and returns a single value.}

\item{quiet}{The default is to give some information along the way
on what data is found. But consider setting this to TRUE for
non-interactive use. Default can be configured using
NMdataConf.}

\item{as.fun}{A function that will be run un the result before
returning. If first input data set is a data.table, the
default is to return a data.table, if not the default is to
return a data.frame. Use whatever to get what fits in with
your workflow. Default can be configured with NMdataConf.}
}
\value{
A data.frame with an overview of elementes and their
    classes of objects in ... Class as defined by as.fun.
}
\description{
Useful interactive tool when merging or binding objects
together. It lists the names of elements that differ in presence
or class across multiple datasets. Before running rbind, you may want
to check the compatibility of the data.
}
\details{
tecnically, this function compares classes of elements in
    lists. However, in relation to NMdata, this will most of the
    time be columns in data.frames.
}
\seealso{
Other DataWrangling: 
\code{\link{dims}()}
}
\concept{DataWrangling}
