% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signif2.R
\name{signif2}
\alias{signif2}
\title{round to fixed number of significant digits}
\usage{
signif2(x, digits = 1, add, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{digits}{number of significant digits to round to. Must be an
integer larger than 0.}

\item{add}{pad with zeros where digits>nchar(x[i]). Currently
not used.}

\item{...}{additional arguments passed to formatC.}
}
\value{
A character vector.
}
\description{
Even if theoretically correct, the built-in 'R' functions 'round'
and 'signif' can be confusing (see examples). 'signif2' is a
simple solution that can be used for reporting results
consistently.
}
\examples{
x <- c(1.24e-4,1.1334e6,1.1,22.00000,10.00,1)
data.frame(x,s.3=signif(x,3),sc.3=as.character(signif(x,3)),s2.3=signif2(x,3))
signif2(c(.2,11.84),2)
## digits has no effect when x==0
signif2(0,1)
signif2(0,3)
}
