/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.Serializable;

public final class Pair<A, B>
implements Comparable<Pair<A, B>>,
Serializable {
    private final A first;
    private final B second;

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public Pair<B, A> swap() {
        return new Pair<B, A>(this.second, this.first);
    }

    public static <A, B> Pair<A, B> of(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair otherPair = (Pair)obj;
        return Pair.isEqualOrNulls(this.first, otherPair.getFirst()) && Pair.isEqualOrNulls(this.second, otherPair.getSecond());
    }

    private static boolean isEqualOrNulls(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public int hashCode() {
        int firstHash = Pair.hashCodeNull(this.first);
        return (firstHash >>> 16 | firstHash << 16) ^ Pair.hashCodeNull(this.second);
    }

    private static int hashCodeNull(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public String toString() {
        return '(' + String.valueOf(this.first) + ',' + this.second + ')';
    }

    @Override
    public int compareTo(Pair<A, B> other) {
        Comparable thisFirst = (Comparable)this.first;
        A thatFirst = other.getFirst();
        int compare = thisFirst.compareTo(thatFirst);
        if (compare != 0) {
            return compare;
        }
        Comparable thisSecond = (Comparable)this.second;
        B thatSecond = other.getSecond();
        return thisSecond.compareTo(thatSecond);
    }
}

