/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayDeque;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import net.myrrix.common.ClassUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public final class IOUtils {
    private IOUtils() {
    }

    public static String urlEncode(String raw) {
        try {
            return URLEncoder.encode(raw, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new AssertionError((Object)uee);
        }
    }

    public static boolean deleteRecursively(File dir) {
        if (dir == null) {
            return false;
        }
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(dir);
        boolean result = true;
        while (!stack.isEmpty()) {
            File topElement = (File)stack.peek();
            if (topElement.isDirectory()) {
                File[] directoryContents = topElement.listFiles();
                if (directoryContents != null && directoryContents.length > 0) {
                    for (File fileOrSubDirectory : directoryContents) {
                        stack.push(fileOrSubDirectory);
                    }
                    continue;
                }
                result = result && ((File)stack.pop()).delete();
                continue;
            }
            result = result && ((File)stack.pop()).delete();
        }
        return result;
    }

    public static InputStream openMaybeDecompressing(File file) throws IOException {
        String name = file.getName();
        FileInputStream in = new FileInputStream(file);
        if (name.endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        if (name.endsWith(".zip")) {
            return new ZipInputStream(in);
        }
        if (name.endsWith(".deflate")) {
            return new InflaterInputStream(in);
        }
        if (name.endsWith(".bz2") || name.endsWith(".bzip2")) {
            return new BZip2CompressorInputStream(in);
        }
        return in;
    }

    public static Reader openReaderMaybeDecompressing(File file) throws IOException {
        return new InputStreamReader(IOUtils.openMaybeDecompressing(file), Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            ByteStreams.copy(in, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(URL url, File file) throws IOException {
        InputStream in = url.openStream();
        try {
            IOUtils.copyStreamToFile(in, file);
        }
        finally {
            Closeables.close(in, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSmallTextFromURL(URL url) throws IOException {
        InputStreamReader in = new InputStreamReader(url.openStream(), Charsets.UTF_8);
        try {
            String string = CharStreams.toString(in);
            return string;
        }
        finally {
            Closeables.close(in, true);
        }
    }

    public static GZIPOutputStream buildGZIPOutputStream(OutputStream delegate) throws IOException {
        try {
            return ClassUtils.loadInstanceOf(GZIPOutputStream.class, new Class[]{OutputStream.class, Boolean.TYPE}, new Object[]{delegate, true});
        }
        catch (IllegalStateException ignored) {
            return new GZIPOutputStream(delegate);
        }
    }

    public static GZIPOutputStream buildGZIPOutputStream(File file) throws IOException {
        return IOUtils.buildGZIPOutputStream(new FileOutputStream(file));
    }

    public static Writer buildGZIPWriter(OutputStream delegate) throws IOException {
        return new OutputStreamWriter((OutputStream)IOUtils.buildGZIPOutputStream(delegate), Charsets.UTF_8);
    }

    public static Writer buildGZIPWriter(File file) throws IOException {
        return IOUtils.buildGZIPWriter(new FileOutputStream(file, false));
    }

    public static BufferedReader buffer(Reader maybeBuffered) {
        return maybeBuffered instanceof BufferedReader ? (BufferedReader)maybeBuffered : new BufferedReader(maybeBuffered);
    }

    public static BufferedReader bufferStream(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGZIPFileEmpty(File f) throws IOException {
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(f));
        try {
            boolean bl = ((InputStream)in).read() == -1;
            return bl;
        }
        finally {
            Closeables.close(in, true);
        }
    }

    public static <T extends Serializable> T readObjectFromFile(File f, Class<T> clazz) throws IOException {
        ObjectInputStream in = new ObjectInputStream(IOUtils.openMaybeDecompressing(f));
        try {
            Serializable result;
            Serializable serializable = result = (Serializable)in.readObject();
            return (T)serializable;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        finally {
            Closeables.close(in, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void writeObjectToFile(File f, T t) throws IOException {
        Preconditions.checkArgument(f.getName().endsWith(".gz"), "File should end in .gz: %s", f);
        ObjectOutputStream out = new ObjectOutputStream(IOUtils.buildGZIPOutputStream(f));
        try {
            out.writeObject(t);
        }
        finally {
            out.close();
        }
    }
}

