% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{Hermite_Coeff}
\alias{Hermite_Coeff}
\title{Coefficients of univariate Hermite polynomials}
\usage{
Hermite_Coeff(N)
}
\arguments{
\item{N}{The order of polynomial}
}
\value{
The vector of coefficients of \eqn{x^N}, \eqn{x^{N-2}}...
}
\description{
Provides the vector of coefficients of the univariate Hermite polynomial
 \eqn{H_N(x)} with variance 1 and order N.
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 4.4   (4.24)
}
\seealso{
Other Hermite: 
\code{\link{Hermite_CoeffMulti}()},
\code{\link{Hermite_N_Cov_X1_X2}()},
\code{\link{Hermite_Nth}()},
\code{\link{Hermite_Poly_HN_Multi}()},
\code{\link{Hermite_Poly_HN}()},
\code{\link{Hermite_Poly_NH_Inv}()},
\code{\link{Hermite_Poly_NH_Multi_Inv}()}
}
\concept{Hermite}
