% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{matr_Commutator_Mixing}
\alias{matr_Commutator_Mixing}
\title{Mixing commutator}
\usage{
matr_Commutator_Mixing(d1, d2, useSparse = FALSE)
}
\arguments{
\item{d1}{dimension of the first group of vectors}

\item{d2}{dimension of the second group of vectors}

\item{useSparse}{T or F.}
}
\value{
A square matrix of dimension \code{prod(d1)*prod(d2)}. If  \code{useSparse=TRUE}  an object of the class
"dgCMatrix" is produced.
}
\description{
Used for the expected value of the T-product of two Hermite polynomials with
dimensions d1 and d2 respectively. With an option for sparse matrices.
}
\examples{
d1 <- c(2, 3, 2)
d2<-  c(3 ,2, 2)
MCM<-matr_Commutator_Mixing(d1,d2)
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021. Formula (4.58) p. 218.
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
