% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataForEstimation.R
\name{DataForEstimation}
\alias{DataForEstimation}
\title{Retrieves data from Excel and builds the database used in the model estimation}
\usage{
DataForEstimation(
  t0,
  tF,
  Economies,
  N,
  FactorLabels,
  ModelType,
  DataFrequency,
  Macro_FullData,
  Yields_FullData,
  DataConnect = NULL,
  W_type = NULL,
  t_First_Wgvar = NULL,
  t_Last_Wgvar = NULL
)
}
\arguments{
\item{t0}{character. Start date of the sample period in the format yyyy-mm-dd.}

\item{tF}{character. End date of the sample period in the format yyyy-mm-dd.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{N}{positive integer. Number of country-specific spanned factors.}

\item{FactorLabels}{list. Labels for all variables present in the model, as returned by \code{\link{LabFac}}.}

\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{DataFrequency}{character. Data frequency. Permissible choices: "Daily All Days", "Daily Business Days", "Weekly", "Monthly", "Quarterly", "Annually".}

\item{Macro_FullData}{list. Full set of macroeconomic data.}

\item{Yields_FullData}{list. Full set of bond yield data.}

\item{DataConnect}{list. Data for computing bilateral connectedness measures. Default is NULL. Required for GVAR-based models.}

\item{W_type}{character. Weight matrix type. Permissible choices: "Full Sample" (all years), "Sample Mean" (average over sample), or a specific year (e.g. "1998", "2005"). Default is NULL.}

\item{t_First_Wgvar}{character. First year for weight matrix computation. Default is NULL.}

\item{t_Last_Wgvar}{character. Last year for weight matrix computation. Default is NULL.}
}
\value{
A list containing:
  \enumerate{
    \item Yields: matrix (\code{J x Td} or \code{CJ x Td}) of bond yields for all countries.
    \item RiskFactors: matrix (\code{K x Td}) of risk factors for all countries.
    \item GVARFactors: list of variables used in VARX estimation (see \code{GVARFactors} data file). NULL if not GVAR-based.
  }
}
\description{
Retrieves data from Excel and builds the database used in the model estimation
}
\section{General Notation}{

  \itemize{
    \item \code{Td}: model time series dimension.
    \item \code{C}: number of countries in the system.
    \item \code{N}: number of country-specific spanned factors.
    \item \code{K}: total number of risk factors.
    \item \code{J}: number of bond yields per country used in estimation.
  }
}

\examples{
DomVar <- c("Eco_Act", "Inflation")
GlobalVar <- c("GBC", "CPI_OECD")
t0 <- "2006-09-01"
tF <- "2019-01-01"
Economies <- c("China", "Brazil", "Mexico", "Uruguay", "Russia")
N <- 2
ModelType <- "JPS original"
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)
DataFrequency <- "Monthly"
MacroData <- Load_Excel_Data(system.file("extdata", "MacroData.xlsx", package = "MultiATSM"))
YieldData <- Load_Excel_Data(system.file("extdata", "YieldsData.xlsx", package = "MultiATSM"))
DataModel <- DataForEstimation(
  t0, tF, Economies, N, FactorLabels, ModelType, DataFrequency,
  MacroData, YieldData
)

}
\seealso{
\code{\link{Load_Excel_Data}}
}
