% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEdensity.R
\name{OptOutputs}
\alias{OptOutputs}
\title{Prepare outputs to export after the model optimization}
\usage{
OptOutputs(
  Y,
  Z,
  mat,
  N,
  dt,
  Wpca,
  K1XQ,
  SSZ,
  LoadAs,
  LoadBs,
  r0,
  se,
  K0Z,
  K1Z,
  Gy.0,
  VarYields,
  y,
  GVARinputs,
  JLLinputs,
  Economies,
  ModelType,
  BS_out = FALSE
)
}
\arguments{
\item{Y}{matrix of yields used in estimation  (J x T or CJ x T)}

\item{Z}{complete set of spanned and unspanned factors (F x T)}

\item{mat}{vector of maturities (in years) of yields used in estimation (J x 1)}

\item{N}{number of country-specific spanned factors}

\item{dt}{time interval unit of the model (scalar)}

\item{Wpca}{matrix of weights of the portfolios observed without errors (N x J or CN x J)}

\item{K1XQ}{risk-neutral feedback matrix (N x N or CN x CN)}

\item{SSZ}{variance-covariance matrix (F x F)}

\item{LoadAs}{list containing the A loadings}

\item{LoadBs}{list containing the B loadings}

\item{r0}{long-run interest rate  (scalar or vector with length C)}

\item{se}{Variance of the portfolio of yields observed with error (scalar).}

\item{K0Z}{intercept from the P-dynamics (F x 1)}

\item{K1Z}{feedback matrix from the P-dynamics (F x F)}

\item{Gy.0}{matrix of contemporaneous terms from the P-dynamics (F x F)}

\item{VarYields}{variance-covariance matrix of the bond yields}

\item{y}{likelihood of each time series (Tx1)}

\item{GVARinputs}{List of inputs from GVAR models}

\item{JLLinputs}{List of inputs from JLL models}

\item{Economies}{string containing the names of the economy to be estimated}

\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{BS_out}{}
}
\description{
Prepare outputs to export after the model optimization
}
\keyword{internal}
