% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCAR.R
\name{MCAR.data}
\alias{MCAR.data}
\title{This function inserts missingness (Missing Complelety at Random - MCAR) into the given data sets.}
\usage{
MCAR.data(misg = NULL, perct = 10, dataList = "Data_List.dat", f.loc)
}
\arguments{
\item{misg}{vector of 0s and 1s. 0 indicates non-missing and 1 indicates items which have missing values. If misg is not indicated all items are considered as missing.}

\item{perct}{Percent of missingness. The default is 10 percent.}

\item{dataList}{List of the names of data sets generated earlier either with the package functions or any other software.}

\item{f.loc}{File location. It indicates where the simulated data sets and "dataList" are located.}
}
\description{
Missing values (MCAR) will be added to the Generated data sets (Generated by sim.skewed() or sim.normal() functions).
The missing values are shown as "NA" in the data files. The new data sets which have missing values will be save as a different data file.
In each data file, the first column shows sample numbers. The second and the other columns show actual data sets for each item.
There also be a file names as "MCAR_List.dat". The file includes names of the data sets which has missing values in it.
}
\examples{

#   Data needed to be generated  at first step.

fc<-fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
fl<-loading.value(nf=3, fl.loads=c(.5,.5,.5,0,0,0,0,0,0,0,0,.6,.6,.6,0,0,0,0,0,0,0,0,.4,.4))
floc<-tempdir()
sim.normal(nd=10, ss=100, fcors=fc, loading<-fl,  f.loc=floc)

 #  Missing values were added  at the second step.

mis.items<-c(1,1,1,0,0,0,0,0)
dl<-"Data_List.dat"  # should be located in the working directory.
MCAR.data(misg = mis.items, perct = 20, dataList = dl, f.loc=floc)
}
\author{
Fatih Orcan
}
