% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_slice}
\alias{coo_slice}
\title{Slices shapes between successive coordinates}
\usage{
coo_slice(coo, ids, ldk)
}
\arguments{
\item{coo}{\code{matrix} of \code{(x; y)} coordinates or any \link{Coo} object.}

\item{ids}{\code{numeric} of length >= 2, where to slice the shape(s)}

\item{ldk}{\code{numeric} the id of the ldk to use as ids, only on \code{Out} and \code{Opn}.
If provided, \code{ids} will be ignored.}
}
\value{
a list of shapes or a list of \link{Opn}
}
\description{
Takes a shape with n coordinates. When you pass this function with at least
two ids (<= n), the shape will be open on the corresponding coordinates and
slices returned as a list
}
\examples{
h <- slice(hearts, 1:5)  # speed purpose only
# single shape, a list of matrices is returned
sh <- coo_slice(h[1], c(12, 24, 36, 48))
coo_plot(sh[[1]])
panel(Opn(sh))
# on a Coo, a list of Opn is returned
# makes no sense if shapes are not normalized first
sh2 <- coo_slice(h, c(12, 24, 36, 48))
panel(sh2[[1]])

# Use coo_slice with `ldk` instead:
# hearts as an example
x <- h \%>\% fgProcrustes(tol=1)
# 4 landmarks
stack(x)
x$ldk[1:5]

# here we slice
y <- coo_slice(x, ldk=1:4)

# plotting
stack(y[[1]])
stack(y[[2]])

# new ldks from tipping points, new ldks from angle
olea \%>\% slice(1:5) \%>\% # for the sake of speed
def_ldk_tips \%>\%
def_ldk_angle(0.75*pi) \%>\% def_ldk_angle(0.25*pi) \%>\%
coo_slice(ldk =1:4) -> oleas
oleas[[1]] \%>\% stack
oleas[[2]] \%>\% stack # etc.

# domestic operations
y[[3]] \%>\% coo_area()
# shape analysis of a slice
y[[1]] \%>\% coo_bookstein() \%>\% npoly \%>\% PCA \%>\% plot(~aut)

}
\seealso{
Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_boundingbox}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_close}}, \code{\link{coo_down}},
  \code{\link{coo_dxy}}, \code{\link{coo_extract}},
  \code{\link{coo_flipx}}, \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}},
  \code{\link{coo_is_closed}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}},
  \code{\link{coo_likely_clockwise}}, \code{\link{coo_nb}},
  \code{\link{coo_perim}}, \code{\link{coo_range}},
  \code{\link{coo_rev}}, \code{\link{coo_right}},
  \code{\link{coo_rotatecenter}}, \code{\link{coo_rotate}},
  \code{\link{coo_sample_prop}},
  \code{\link{coo_samplerr}}, \code{\link{coo_sample}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trimbottom}}, \code{\link{coo_trimtop}},
  \code{\link{coo_trim}}, \code{\link{coo_up}},
  \code{\link{is_equallyspacedradii}}
}
