% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-PCA.R
\name{rePCA}
\alias{rePCA}
\title{"Redo" a PCA on a new Coe}
\usage{
rePCA(PCA, Coe)
}
\arguments{
\item{PCA}{a \link{PCA} object}

\item{Coe}{a \link{Coe} object}
}
\description{
Basically reapply rotation to a new Coe object.
}
\note{
Quite experimental. Dimensions of the matrices and methods must match.
}
\examples{
data(bot)
b <- filter(bot, type=="beer")
w <- filter(bot, type=="whisky")

bf <- efourier(b, 8)
bp <- PCA(bf)

wf <- efourier(w, 8)

# and we use the "beer" PCA on the whisky coefficients
wp <- rePCA(bp, wf)

plot(wp)

plot(bp, eig=FALSE)
points(wp$x[, 1:2], col="red", pch=4)

}
