% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-meanshapes.R
\name{plot_mshapes}
\alias{plot_mshapes}
\title{Pairwise comparison of a list of shapes}
\usage{
plot_mshapes(x, size = 3/4, col2 = "#FF0000")
}
\arguments{
\item{x}{a list of shapes (eg as returned by \link{mshapes})}

\item{size}{numeric shrinking factor for shapes (and \link{coo_template};
3/4 by default)}

\item{col2}{color as hexadecimal ("#FF0000", eg red, by default)}
}
\description{
"Confusion matrix" of a list of shapes. See examples.
}
\note{
Inspired by Chitwood et al. (2016) New Phytologist
}
\examples{
bot \%>\% efourier(6) \%>\% mshapes("type") \%>\% plot_mshapes
# above, a shortcut for working with the result of mshapes
# but works on list of shapes, eg:
leaves <- shapes \%>\% slice(grep("leaf", names(shapes))) \%$\% coo
class(leaves)
leaves \%>\% plot_mshapes(col2="#0000FF")
}

