\name{model.map}
\alias{model.map}
\alias{model.run}

\title{ Model Building and Map making }
\description{
  Create sophisticated models of training data and validate the models with an independant test set, cross validation, or in the case of Random Forest Models, with Out OF Bag (OOB) predictions on the training data.  It will creat graphs and tables of the model validation results.  It will apply these models to GIS .img files of predictors to create detailed prediction surfaces.  It will handle large predictor files for map making, by reading in the \code{.img} files in chuncks, and output to the \code{.txt} file the prediction for each data chunk, before reading the next chenk of data.
}
\usage{
model.map(model.obj = NULL, model.type = NULL, qdata.trainfn = NULL, qdata.testfn = NULL, folder = NULL, MODELfn = NULL, rastLUT = NULL, rastLUTfn = NULL, rastnmVector = NULL, predList = NULL, predFactor = FALSE, response.name = NULL, response.type = NULL, unique.rowname = NULL, seed = NULL, predict = NULL, MODELpredfn = NULL, na.action = "na.omit", v.fold = NULL, diagnostics = predict, device.type = NULL, DIAGNOSTICfn = NULL, jpeg.res = 72, device.width = 7,  device.height = 7, cex=par()$cex, req.sens, req.spec, FPC, FNC, ntree = 500, mtry = NULL, n.trees = NULL, shrinkage = 0.001, interaction.depth = 10, bag.fraction = 0.5, train.fraction = 1, n.minobsinnode = 10, map = NULL, numrows = 500, map.sd = FALSE, asciifn = NULL, asciifn.mean = NULL, asciifn.stdev = NULL, asciifn.coefv = NULL)
}

\arguments{

  \item{model.obj}{ \code{R} model object.  The model object to use for prediction, if the model has been previously created.  The model object must be of type RF or SGB.  (Eventually planned to include "GAM".)  If \code{NULL} (the default), a model is generated of type specified by the argument \code{model.type}.  }

  \item{model.type}{ String.  Model type.  \code{"RF"} or \code{"SGB"}.  (Eventually planned to include \code{"GAM"}.) If \code{model.obj} is specified, the \code{model.type} will be extracted from \code{model.obj}, and the argument \code{model.type} will be ignored (with a warning). }

  \item{qdata.trainfn}{String.  The name (full path or base name with path specified by \code{folder}) of the training data file used for building the model (file should include columns for both response and predictor variables).  The file must be a comma-delimited file \code{*.csv} with column headings. \code{qdata.trainfn} can also be an \code{R} dataframe. If predictions will be made (\code{predict = TRUE} or \code{map=TRUE}) the predictor column headers must match the names of the raster layer files, or a \code{rastLUT} must be provided to match predictor columns to the appropriate raster and band.  If \code{qdata.trainfn = NULL} (the default), a GUI interface prompts user to browse to the training data file.  }

  \item{qdata.testfn}{String.  The name (full path or base name with path specified by \code{folder}) of the independent data set for testing (validating) the model's predictions.  The file must be a comma-delimited file \code{".csv"} with column headings and the column headings must be the same as those in the training data file.  \code{qdata.testfn} can also be an \code{R} dataframe. If \code{qdata.testfn = NULL} (default), a GUI interface asks user if there is a test set available, then prompts user to browse to the test data file.  If no test set is desired (for example, cross-fold validation will be performed, or for RF models, Out-Of-Bag estimation, set \code{qdata.testfn = FALSE}. If no test set is given, and \code{qdata.testfn} is not set to \code{FALSE}, the GUI interface asks if a proportion of the data should be set aside as an independent test set.  If this is desired, the user will be prompted to specify the proportion to set aside as test data, and two new data files will be generated in the out put folder.  The new file names will be the original data file name with \code{"_train"} and \code{"_test"} appended to the end of the file names.}

  \item{folder}{ String.  The folder used for all output from predictions and/or maps.  Do not add ending slash to path string.  If \code{folder = NULL} (default), a GUI interface prompts user to browse to a folder.  To use the working directory, specify \code{folder = getwd()}.}

  \item{MODELfn}{ String.  The file name to use to save the generated model object.  If \code{MODELfn = NULL} (the default), a default name is generated by pasting \code{model.type_response.type_response.name}. If the other output filenames are left unspecified, \code{MODELfn} will be used as the basic name to generate other output filenames. The filename can be the full path, or it can be the simple basename, in which case the output will be to the folder specified by \code{folder}.}

  \item{rastLUT}{ Dataframe.  A data frame of raster information used to make a map.  This data frame can be an \code{R} object or read in from a comma-delimited file using the example code below.  The \code{rastLUT} must be given if a map is desired (\code{map = TRUE}) or if a model is being generated and \code{predList = NULL}.  The \code{rastLUT} must include 3 columns: (1) the full path and name of the raster file; (2) the shortname of each predictor / raster layer (band); (3) the layer (band) number.  The shortname (column 2) must match the names \code{predList}, the predictor column names in training/test data set (\code{qdata.trainfn} and \code{qdata.testfn}, and if \code{model.obj} is already built, the predictor names in this model object.

Set \code{rastLUT = FALSE} if no raster LUT is available and you do not want to be propted by a gui interface.  In this case, if a map is to be produced, column headers in qdata MUST be of the following format:  [name of rast]b[layer number].  See column 2 of the example below. 

Example of comma-delimited file:

\tabular{llllll}{
	  \tab \tab \tab \code{C:/button_test/tc99_2727subset.img,} \tab \code{tc99_2727subsetb1,} \tab \code{1}\cr
	  \tab \tab \tab \code{C:/button_test/tc99_2727subset.img,} \tab \code{tc99_2727subsetb2,} \tab \code{2}\cr
	  \tab \tab \tab \code{C:/button_test/tc99_2727subset.img,} \tab \code{tc99_2727subsetb3,} \tab \code{3}}
	 
Example code for reading in file:

\code{read.table(file="C:/predict_button/testdata/rastLUT_example.csv",
sep=",",header=FALSE, check.names=F, stringsAsFactors=F)}}

  \item{rastLUTfn}{ String.  The file name (full path or base name with path specified by \code{folder}) of a \code{.csv} file for a \code{rastLUT}. This file must follow the format described above for \code{rastLUT}. It is not necessary to specify both \code{rastLUT} and \code{rastLUTfn}. If both are given, \code{model.map()} will use \code{rastLUT}.}

  \item{rastnmVector}{ Vector of character Strings.  The file names and paths (for Imagine Image files) or folder names and paths (for ArcInfo Grids) of rasters to be used to generate a selection list of possible predictors. Only needed if you are creating a model, and \code{predList} and \code{rastLUT} and \code{rastLUTfn} are all \code{NULL} }

  \item{predList}{ String.  A character vector of the predictor short names used to build the model.  These names must match the column names in the training/test data files and the names in column two of the \code{rastLUT}.  If \code{predList = NULL} (the default), a GUI interface prompts user to select predictors from column 2 of \code{rastLUT}. 

If both \code{predList = NULL} and \code{rastLUT = NULL}, then a GUI interface prompts user to browse to rasters used as predictors, and select from a generated list, the individual layers (bands) of rasters used to build the model.  In this case (i.e., \code{rastLUT = NULL}), predictor column names of training data must be standard format, consisting of raster stack name followed by b1, b2, etc..., giving the band number within each stack (Example: \code{stacknameb1}, \code{stacknameb2}, \code{stacknameb3}, ...). 
 }

  \item{predFactor}{ String.  A character vector of predictor short names of the predictors from \code{predList} that are factors (i.e categorical predictors).  These must be a subset of the predictor names given in \code{predList} Categorical predictors may have multiple categories.}

  \item{response.name}{ String.  The name of the response variable used to build the model.  If \code{response.name = NULL}, a GUI interface prompts user to select a variable from the list of column names from training data file.  \code{response.name} must be column name from the training/test data files. }

  \item{response.type}{ String.  Response type: \code{"binary"} or \code{"continuous"}.  binary response must be binary 0/1 variable with only 2 categories.  All zeros will be treated as one category, and everything else will be treated as the second category. }

  \item{unique.rowname}{ String.  The name of the unique identifier used to identify each row in the training data.  If \code{unique.rowname = NULL}, a GUI interface prompts user to select a variable from the list of column names from the training data file.  If \code{unique.rowname = FALSE}, a variable is generated of numbers from \code{1} to \code{nrow(qdata)} to index each row. }

  \item{seed}{ Integer.  The number used to initialize randomization to build RF or SGB models.  If you want to produce the same model later, use the same seed.  If \code{seed = NULL} (the default), a new seed is created each run. }

  \item{predict}{ Logical.  Model validation.  If \code{predict = TRUE}, validation predictions will be made.  If \code{predict = FALSE}, no validation predictions will be made.  If \code{predict = TRUE}, a \code{*.csv} file of the unique id, observed, and predicted values is generated and put in the specified (or default) folder.  If a test set is provided, the predictions will be made on the test set.  If \code{v.fold} equals a number greater than \code{1}, cross validation will be used on the training data.  If no test set is provided and \code{v.fold = FALSE}, predictions will be made on the training set.  For Random Forest Models, Out of Bag (OOB) predictions will be made on the training data.  For Stochastic Gradient Boosting (SGB) models, predictions on the training data will lead to over optimistic estimates of model quality.}

  \item{MODELpredfn}{ String.  Model validation.  The name of the validation prediction \code{*.csv} file.  Only used if \code{predict = TRUE}. The filename can be the full path, or it can be the simple basename, in which case the output will be to the folder specified by \code{folder}. If \code{MODELpredfn = NULL} (the default), a default name is created by pasting \code{modelfn} and \code{"_pred.csv"}.}

  \item{na.action}{String.  Model validation.  Specifies the action to take if there are \code{NA} values in the prediction data or if there is a level or class of a ctegorical predictor variable in the validation test set or the production (mapping) data set, but not in the training data set.  There are 2 options: (1) \code{na.action = "na.omit"} (the default) where any data point or pixel with any new levels for any of the factored predictors is returned as \code{-9999} (the \code{NODATA} value); (2) \code{na.action = "na.roughfix"} where a missing categorical predictor for a data point or pixel is replaced with the most common category for that predictor, and a missing continuous predictor is replaced with the median for that predictor.   }

  \item{v.fold}{ Integer (or logical \code{FALSE}).  Model validation.  The number of cross validation folds to use when making validation predictions on the training data.  If set to \code{v.fold = FALSE} and no test data is supplied, validation predictions will be made on the training data.  For RF models, if \code{v.fold = FALSE}, Out-of-Bag (OOB) predictions will be made on the training data, for SGB models, predictions will still be made on the training data, but they will give an over optimistic view of model quality.  If a test set is supplied, \code{v.fold} will default to \code{FALSE} and validation predictions will be made on the test data.  }

  \item{diagnostics}{ Logical.  Model validation.  If \code{diagnostics = TRUE}, the following diagnostic statistics and graphs will be generated for validation predictions: 

A variable importance graph is made. 

If \code{response.type = "binary"}, a summary graph is made using the \code{PresenceAbsence} package and a \code{*.csv} spreadsheet is created of optimized thresholds by several methods with their associated error statistics.

If \code{response.type = "continuous"} a scatterplot of observed vs.  predicted is created with a simple linear regression line.  The graph is labeled with slope and intercept of this line as well as Pearson's and Spearman's correlation coefficients.

Note: \code{diagnostics} will only be performed if \code{predict = TRUE}.

 }
  \item{device.type}{ String or vector of strings.  Model validation.  One or more device types for graphical output from model validation diagnostics. 

Current choices:

\tabular{lllll}{
	  \tab \tab \tab \code{"default"} \tab default graphics device\cr
	  \tab \tab \tab \code{"jpeg"} \tab \code{*.jpg} files\cr
	  \tab \tab \tab \code{"pdf"} \tab \code{*.pdf} files\cr
	  \tab \tab \tab \code{"postscript"} \tab \code{*.ps} files\cr
	  \tab \tab \tab \code{"win.metafile"} \tab \code{*.emf} files }
 }

  \item{DIAGNOSTICfn}{ String.  Model validation.  Name used as base to create names for output files from model validation diagnostics.  The filename can be the full path, or it can be the simple basename, in which case the output will be to the folder specified by \code{folder}.  Defaults to \code{DIAGNOSTICfn = MODELfn} followed by the appropriate suffixes (i.e. \code{".csv"}, \code{".jpg"}, etc...). }

  \item{jpeg.res}{ Integer.  Model validation.  Pixels per inch for jpeg plots.  The default is 72dpi, good for on screen viewing. For printing, suggested setting is 300dpi. }

  \item{device.width}{ Integer.  Model validation.  The device width for diagnostic plots in inches. }

  \item{device.height}{ Integer.  Model validation.  The device height for diagnostic plots in inches. }

  \item{cex}{ Integer.  Model validation.  The cex for diagnostic plots. }

  \item{req.sens}{ Numeric.  Model validation.  The required sensitivity for threshold optimization for binary response model evaluation. }

  \item{req.spec}{ Numeric.  Model validation.  The required specificity for threshold optimization for binary response model evaluation. }

  \item{FPC}{ Numeric.  Model validation.  The False Positive Cost for threshold optimization for binary response model evaluation. }

  \item{FNC}{ Numeric.  Model validation.  The False Negative Cost for threshold optimization for binary response model evaluation. }

  \item{ntree}{ Integer.  RF models.  The number of random forest trees for a RF model.  The default is 500 trees. }
 
  \item{mtry}{ Integer.  RF models.  Number of variables to try at each node of Random Forest trees.  By default, will use the \code{"tuneRF()"} function to optimize \code{mtry}. }

  \item{n.trees}{ Integer.  SGB models.  The number of stochastic gradient boosting trees for an SGB model. If \code{n.trees=NULL} (the default) the model creation code will increase the number of trees 100 at a time until OOB error rate stops improving. The \code{gbm} package warns that \code{OOB generally underestimates the optimal number of iterations although predictive performance is reasonably competitive.} Regardless of the value of the \code{n.trees} argument, the \code{gbm} function \code{gbm.perf()} will be used to select from the total calculated trees, the best number of trees for model predictions, with argument \code{method="OOB"}.}

  \item{shrinkage}{ Numeric. SGB models.  A shrinkage parameter applied to each tree in the expansion. Also known as the learning rate or step-size reduction. }

  \item{interaction.depth}{ Integer.  SGB models.  The maximum depth of variable interactions. \code{interaction.depth = 1} implies an additive model, \code{interaction.depth = 2} implies a model with up to 2-way interactions, etc... }

  \item{bag.fraction}{ Numeric.  SGB models.  \code{ bag.fraction} must be a number between \code{0} and \code{1}, giving the fraction of the training set observations randomly selected to propose the next tree in the expansion.  This introduces randomnesses into the model fit. If \code{ bag.fraction < 1} then running the same model twice will result in similar but different fits. }

  \item{train.fraction}{ Numeric.  SGB models.  The first \code{ train.fraction * nrows(data)} observations are used to fit the model and the remainder are used for computing out-of-sample estimates of the loss function. }

  \item{n.minobsinnode}{ Integer.  SGB models.  Minimum number of observations in the trees terminal nodes. Note that this is the actual number of observations not the total weight. }

  \item{map}{ Logical.  Map Production.  If \code{map = TRUE}, predictions will be made across the extent of the raster layers.  If \code{map = FALSE}, no predictions will be made. If \code{map = NULL} (the default), a GUI window will prompt you to select whether to creat a map.}

  \item{numrows}{ Integer.  Map Production.  The number of rows to be predicted at a time.}

  \item{map.sd}{ Logical.  Map Production.  If \code{map.sd = TRUE}, maps of mean, standard deviation, and coefficient of variation of the predictions from all the trees are generated for each pixel.  If \code{map.sd = FALSE} (the default), only the predicted probability map will be built. This option is only available if the \code{model.type = "RF"} the \code{response.type = "continuous"}.  Note: This option requires much more available memory. If you get the error \code{"..cannot allocate vector of size..."}, you must reduce the value of \code{numrow}.  

The names of the additional maps default to: 

\tabular{llll}{
	  \tab \tab \tab \code{folder/model.type_response.type_response.name_mean.txt}  \cr
	  \tab \tab \tab \code{folder/model.type_response.type_response.name_stdev.txt}  \cr
	  \tab \tab \tab \code{folder/model.type_response.type_response.name_coefv.txt} }
}

  \item{asciifn}{ String.  Map Production.  Filename of output file for map production.  The filename can be the full path, or it can be the simple basename, in which case the output will be to the folder specified by \code{folder}. If \code{asciifn = NULL} (the default), a name is created by pasting \code{modelfn} and \code{"_map.txt"}. }

  \item{asciifn.mean}{ String.  Map Production.  Used if \code{map.sd = TRUE} and \code{response.type = "continuous"}.  Filename of output file for mean of trees. The filename can be the full path, or it can be the simple basename, in which case the output will be to the folder specified by \code{folder}. If \code{asciifn.mean = NULL} (the default), a name is created by pasting \code{modelfn} and \code{"_map_mean.txt"}.}

  \item{asciifn.stdev}{ String.  Map Production.  Used if \code{map.sd = TRUE} and \code{response.type = "continuous"}.  Filename of output file for standard deviation of trees. The filename can be the full path, or it can be the simple basename, in which case the output will be to the folder specified by \code{folder}. If \code{asciifn.stdev = NULL} (the default), a name is created by pasting \code{modelfn} and \code{"_map_stdev.txt"}.}

  \item{asciifn.coefv}{ String.  Map Production.  Used if \code{map.sd = TRUE} and \code{response.type = "continuous"}.  Filename of output file for coefficient of variation of trees. The filename can be the full path, or it can be the simple basename, in which case the output will be to the folder specified by \code{folder}. If \code{asciifn.coefv = NULL} (the default), a name is created by pasting \code{modelfn} and \code{"_map_coefv.txt"}.}

}
\details{
  This package provides a push button appraoch to complex model building and production mapping.  It contains two functions: a simple function \code{get.test()} that can be used to radomly divide a training dataset into training and test/validation sets; and the workhorse, "do every thing" function nick named "The Button", and called with \code{model.map()}.

\code{model.map()} can be run in a traditional R command mode, where all arguments are specified in the function call.  However it can also be used in a full push button mode, where you type in the simple command \code{model.map()}, and GUI pop up windows will ask questions about the type of model, the file locations of the data, etc...

When running \code{model.map()} on non-Windows platforms, file names and folders need to be specified in the argument list, but other pushbutton selections are handled by the \code{select.list()} function, which is platform independent. 

Random Forest is implemented through the \code{randomForest} package within \code{R}.  Random Forest is more user friendly than Stochastic Gragient Boosting, as it has fewer parameters to be set by the user, and is less sensitive to tuning of these parameters.  A Random Forest model consists of multiple trees that vote on predictions.  For each tree a random subset of the training data is used to construct the tree, with the remaining data points used to construct out-of-bag (OOB) error estimates.  At each node of the tree a random selection of predictors is chosen to determine the split.  The number of predictors used to select the splits (argument \code{mtry}) is the primary user specified parameter that can affect model performance.  By default this parameter will be automatically optimized using the \code{tuneRF()} function.  Random Forest will not over fit data, therefore the only penalty of increasing the number of trees is computation time.  Random Forest can compute variable importance, an advantage over some "black box" modeling techniques if it is important to understand the ecological relationships underlying a model (Brieman, 2001).

Stochastic gradient boosting (Friedman 2001, 2002), is related to both boosting and bagging.  Many small classification or regression trees are built sequentially from "pseudo"-residuals (the gradient of the loss function of the previous tree). 

At each iteration, a tree is built from a random sub-sample of the dataset (selected without replacement) and an incremental improvement in the model.  Using only a fraction of the training data increases both the computation speed and the prediction accuracy, while also helping to avoid over-fitting the data.  An advantage of stochastic gradient boosting is that it is not necessary to pre-select or transform predictor variables.  It is also resistant to outliers, as the steepest gradient algorithm emphasizes points that are close to their correct classification.  Stochastic gradient boosting is implemented through the \code{gbm} package within \code{R}.  

One disadvantege of Stochastic Gradient Boosting, compared to Random Forest, is increased number of user specified parameters, and the SGB models tend to be more sensitive to these parameters.  Model fitting parameter options include distribution, interaction depth, bagging fraction, shrinkage rate, and training fraction.  These parameters can be set in the argument list when calling \code{model.map()}.  Values for these parameters other than the defaults can not be set by point and click in the GUI pop up windows, and must be set in the argument list when calling \code{model.map()}.  Friedman (2001, 2002) and Ridgeway (1999) provide guidelines on appropriate settings for model fitting options.

Also, unlike Random Forest models, in Stochastic Gradient Boosting, there is a penaly for using too many trees. The default behavior in \code{model.map()} is to increase the number of trees 100 at a time until the model stops improving, then call the \code{gbm} subfunction \code{gbm.perf(method="OOB")} to select the best number of iterations. ALternatively, the \code{model.map()} argument \code{ntrees} can be used to set some large number of trees to be calculated all at once and, again, the \code{gbm.perf(method="OOB")} function will be used to select the best number of trees. Note that the \code{gbm} package warns that \code{"OOB generally underestimates the optimal number of iterations although predictive performance is reasonably competitive."} The \code{gbm} package offers two alternative techniques for calculating the best number of trees, but these are not yet implemented in the \code{ModelMap} package, as they require the use of a formula interface for model building. 

For Presence-Absence data, the package \code{PresenceAbsence} is used for model validation.

For map making, the package \code{rgdal} is used to read \code{.img} files. The data for production mapping should be in the form of pixel-based raster layers representing the predictors in the model. If there is more than one predictor or raster layer, the layers must all have the same number of columns and rows. The layers must also have the same extent, projection, and pixel size, for effective model development and accuracy. The layers must also be in either ESRI Grid or ERDAS Imagine image (single or multi-band) raster data formats, having continuous or categorical data values. The R package \code{rgdal} is used to read spatial rasters into R.

When creating maps of non-rectangular study regions there may be large portions of the rectangle where you have no predictors, and are unintrested in making predictions. The suggeted value for the pixels outside the study area is \code{-9999}. These pixels will be ignored in the predictions, thus saving computing time, and will be exported as \code{-9999}. Any value other than \code{-9999} will be treated as a legal data value and a prediction will be generated for each pixel. Note: in Imagine image files, if the specified \code{NODATA} is set as \code{-9999}, any \code{-9999} pixels will be read into R as \code{NA}, and if \code{na.action = "na.roughfix"}, predicitons will be attempted for these pixels. This will cause the computation time to increase, and these predictions will need to be masked out when the final map is imported back into a GIS sytem.

The function \code{model.map()} outputs an ASCII grid file of map information suitable to be imported into a GIS. Small maps can also be imported back into R using the function \code{read.asciigrid()} from the \code{sp} package.
}
\value{

The function will return the model object. Additionally, depending on the options selected, it may also write several different things to disk, in the folder specified by \code{folder}. These include:

  \item{\code{model.obj = NULL} }{ the \code{R} model object}
  \item{\code{predict = TRUE} }{ .csv file of observed and predicted values}
  \item{\code{diagnostics = TRUE} }{ variable importance and summary graphs of file type specified by \code{device.type} (i.e. .jpg, .ps, or .emf files) }
  \item{\code{diagnostics = TRUE & response.type = "binary"} }{ .csv file of thresholds optimized by multiple different criteria}	
  \item{\code{map = TRUE} }{ .txt files of map information suitable to be imported into GIS}
  \item{\code{ } }{ .txt file giving the values of each argument as choosen from GUI propts used for the function call}

}
\references{ 
Breiman, L. (2001) Random Forests. Machine Learning, 45:5-32.

Friedman, J.H. (2001). Greedy function approximation: a gradient boosting machine. Ann. Stat., 29(5):1189-1232.

Friedman, J.H. (2002). Stochastic gradient boosting. Comput. Stat. Data An., 38(4):367-378.

Liaw, A. and  Wiener, M. (2002). Classification and Regression by randomForest. R News 2(3), 18--22.

Ridgeway, G., (1999). The state of boosting. Comp. Sci. Stat. 31:172-181
 }

\author{ Elizabeth Freeman and Tracey Frescino }
\note{ 
}
\seealso{ \code{\link{get.test}}}
\examples{

###########################################################################
############################# Run this set up code: #######################
###########################################################################

# set seed:
seed=38

# Define training and test files:

qdata.trainfn = paste(system.file(package="ModelMap"),"/external/DATATRAIN.csv",sep="")
qdata.testfn  = paste(system.file(package="ModelMap"),"/external/DATATEST.csv",sep="")

# Define folder for all output:
folder=getwd()	

# Create a list of the filenames (including paths) for the rast Look up Tables:
rastLUTfn=list( paste(system.file(package="ModelMap"),"/external/LUT_2001.csv",sep=""),
                paste(system.file(package="ModelMap"),"/external/LUT_2004.csv",sep=""))


# Load rast LUT tables, and add path to the filenames in column 1:
rastLUT<-lapply(rastLUTfn, function(x){	y <- read.table(x,header=FALSE,sep=",",stringsAsFactors=FALSE)
                                        y[,1] <- paste(system.file(package="ModelMap"),"external",y[,1],sep="/")
                                        return(y)})

# Define identifier for individual training and test data points:
unique.rowname="ID"

# Define Number of rows of raster to read in at one time
# if crashes with warning: "unable to assign..." lower this number

numrows=500


###########################################################################
############## Pick one of the following sets of definitions: #############
###########################################################################


########## Continuous Response, Continuous Predictors ############

#file name to store model:
MODELfn="RF_Bio_TC"

#file name for validation predictions:						
MODELpredfn="RF_Bio_TC_PRED.csv"				

#names from column 2 of rastLUT:
predList=c("TCB","TCG","TCW")	

#define which predictors are categorical:
predFactor=FALSE	

# Response name and type:
response.name="BIO"
response.type="continuous"


# Map name:
asciifn<-c("RF_Bio_TC_01.txt","RF_Bio_TC_04.txt")
asciifn<-paste(folder,asciifn,sep="/")

########## binary Response, Continuous Predictors ############

#file name to store model:
MODELfn="RF_CONIFTYP_TC"

#file name for validation predictions:						
MODELpredfn="RF_CONIFTYP_TC.csv"				

#names from column 2 of rastLUT:
predList=c("TCB","TCG","TCW")		

#define which predictors are categorical:
predFactor=FALSE

# Response name and type:
response.name="CONIFTYP"

# This variable is 1 if a conifer or mixed conifer type is present, 
# otherwise 0.

response.type="binary"


# Map name:
asciifn<-c("RF_CONIFTYP_TC_01.txt","RF_CONIFTYP_TC_04.txt")
asciifn<-paste(folder,asciifn,sep="/")

########## Continuous Response, Categorical Predictors ############

# In this example, NLCD is a categorical predictor.
#
# You must decide what you want to happen if there are categories
# present in the data to be predicted (either the validation/test set
# or in the image file) that were not present in the original training data.
# Choices:
#       na.action = "na.omit"
#                    Any validation datapoint or image pixel with a value for any
#                    categorical predictor not found in the training data will be
#                    returned as NA.
#       na.action = "na.roughfix"
#                    Any validation datapoint or image pixel with a value for any
#                    categorical predictor not found in the training data will have
#                    the most common category for that predictor substituted,
#                    and the a prediction will be made.

# You must also let R know which of the predictors are categorical, in other
# words, which ones R needs to treat as factors.
# This vector must be a subset of the predictors given in predList

#file name to store model:
MODELfn="RF_BIO_TCandNLCD"

#file name for validation predictions:						
MODELpredfn="RF_BIO_TCandNLCD_PRED.csv"				

#names from column 2 of rastLUT:
predList=c("TCB","TCG","TCW","NLCD")

#define which predictors are categorical:
predFactor=c("NLCD")

# Response name and type:
response.name="BIO"
response.type="continuous"


# Map name:
asciifn<-c(	"RF_BIO_TCandNLCD_01.txt","RF_BIO_TCandNLCD_04.txt")
asciifn<-paste(folder,asciifn,sep="/")

###########################################################################
############### Then run this code to building model: #####################
###########################################################################


### create model before batching (only run this code once ever!) ###

model.obj = model.map( model.obj=NULL,
                       model.type="RF",
                       qdata.trainfn=qdata.trainfn,
                       qdata.testfn=qdata.testfn,
                       folder=folder,		
                       MODELfn=MODELfn,
                       rastLUT=rastLUT[[1]],
                       predList=predList,
                       predFactor=predFactor,
                       response.name=response.name,
                       response.type=response.type,
                       unique.rowname=unique.rowname,
                       seed=seed,
                # Model Validation Arguments
                       predict=FALSE,
                # Mapping arguments
                       map=FALSE
)

###########################################################################
#### Then Run this code make validation predictions and diagnostics: ######
###########################################################################

model.obj = model.map( model.obj=model.obj,
                       qdata.trainfn=qdata.trainfn,
                       qdata.testfn=qdata.testfn,   #set qdata.testfn=FALSE to use OOB on training data
                       folder=folder,		
                       MODELfn=MODELfn,
                       rastLUT=rastLUT[[1]],
                       predList=predList,
                       predFactor=predFactor,
                       response.name=response.name,
                       response.type=response.type,
                       unique.rowname=unique.rowname,
                       seed=seed,
                # Model Validation Arguments
                       predict=TRUE,
                       diagnostics=TRUE,
                       DIAGNOSTICfn=MODELfn,
                       device.type=c("jpeg","pdf"),	
                       MODELpredfn=MODELpredfn,
                       v.fold=FALSE,
                       na.action="na.roughfix",
                # Mapping arguments
                       map=FALSE
)


###########################################################################
################# Then Run this code to create maps: ######################
###########################################################################

### button - Batch (must have already created model) ###

load(paste(folder,"/",MODELfn,sep=""))

for(i in 1:length(rastLUTfn)){

        print("##########################################################")
        print(paste("Starting",asciifn[i]))
        print("##########################################################")

        model.obj = model.map( model.obj=model.obj,
                               folder=folder,		
                               rastLUT=rastLUT[[i]],
                               seed=seed,
                         # Model Validation Arguments
                               predict=FALSE,	
                               na.action="na.roughfix",
                         # Mapping arguments
                               map=TRUE,
                               numrows = numrows,						
                               asciifn=asciifn[i]
                               )
}



}

\keyword{ models }

