% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriggerMSG.R
\name{TriggerMSG}
\alias{TriggerMSG}
\title{Send message from mobile triggers}
\usage{
TriggerMSG(path = NULL, subject = NULL, body = NULL, html = F,
  authenticate = T, debug = F, ...)
}
\arguments{
\item{path}{string, top level folder called the [TriggerPath]}

\item{subject}{string, subject text of the message}

\item{body}{string, body text of the message}

\item{html}{boolean, use HTML or plain text.}

\item{authenticate}{boolean, use authentication for SMTP sign-in}

\item{debug}{boolean, option to turn on mailR debugging}

\item{...}{additional options to pass through to mailR::send.mail()}
}
\value{
message to be sent to mobile email client.
}
\description{
Function is a wrapper for mailR::send.mail() function. Function
gets its mail settings from mailsettings.R file in the [TriggerPath]
}
\examples{
\donttest{
####################################################
# Send Message with Moble Triggers                 #
####################################################
# the function internals will call your mailsettings
# from the mailsettings.R file in your trigger root folder

  TriggerMSG(path = 'c:/triggers',
             body = "hello world",
             subject = "Script List",
             html = F, authenticate = T
  )
 }
}
