% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixregression.R
\name{mixlin}
\alias{mixlin}
\title{Traditional MLE based mixture regression assuming the normal error density}
\usage{
mixlin(x, y, k = 2, numini = 20)
}
\arguments{
\item{x}{explanatory variables matrix with rows for each observation}

\item{y}{response variable vector}

\item{k}{number of components, default is 2}

\item{numini}{number of initial values, default is 20.}
}
\value{
theta: estimated parameters matrix, the columns are beta(intercept, slopes), sigma, proportion for each component.
likelihood: likelihood of the estimated parameters
run: number of iterations to converge
diflh: difference of likelihood of last iteration and second to last iteration
}
\description{
Traditional MLE based mixture regression assuming the normal error density
}
\examples{
library(fpc)
data('tonedata')
y=tonedata$tuned
x=tonedata$stretchratio
k=160;x[151:k]=0;y[151:k]=5
est=mixlin(x,y,2,numini = 1);
mle=est$theta

}
