% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixt.R
\name{rmatrixinvt}
\alias{rmatrixinvt}
\alias{dmatrixinvt}
\title{Distribution functions for matrix variate inverted t distributions}
\usage{
rmatrixinvt(
  n,
  df,
  mean,
  L = diag(dim(as.matrix(mean))[1]),
  R = diag(dim(as.matrix(mean))[2]),
  U = L \%*\% t(L),
  V = t(R) \%*\% R,
  list = FALSE,
  array = NULL
)

dmatrixinvt(
  x,
  df,
  mean = matrix(0, p, n),
  L = diag(p),
  R = diag(n),
  U = L \%*\% t(L),
  V = t(R) \%*\% R,
  log = FALSE
)
}
\arguments{
\item{n}{number of observations for generation}

\item{df}{degrees of freedom (\eqn{>0}, may be non-integer),
\verb{df = 0, Inf} is allowed and will return a normal distribution.}

\item{mean}{\eqn{p \times q}{p * q} This is really a 'shift' rather than a
mean, though the expected value will be equal to this if
\eqn{df > 2}}

\item{L}{\eqn{p \times p}{p * p}  matrix specifying relations among the rows.
By default, an identity matrix.}

\item{R}{\eqn{q \times q}{q * q}  matrix specifying relations among the
columns. By default, an identity matrix.}

\item{U}{\eqn{LL^T}  - \eqn{p \times p}{p * p}   positive definite matrix for
rows, computed from \eqn{L} if not specified.}

\item{V}{\eqn{R^T R}  - \eqn{q \times q}{q * q}  positive definite matrix for
columns, computed from \eqn{R}  if not specified.}

\item{list}{Defaults to \code{FALSE} . If this is \code{TRUE} , then the
output will be a list of matrices.}

\item{array}{If \eqn{n = 1}  and this is not specified and \code{list}  is
\code{FALSE} , the function will return a matrix containing the one
observation. If \eqn{n > 1} , should be the opposite of \code{list} .
If \code{list}  is \code{TRUE} , this will be ignored.}

\item{x}{quantile for density}

\item{log}{logical; in \code{dmatrixt}, if \code{TRUE}, probabilities
\code{p} are given as \code{log(p)}.}
}
\value{
\code{rmatrixinvt} returns either a list of \eqn{n}
\eqn{p \times q}{p * q}  matrices or
a \eqn{p \times q \times n}{p * q * n}  array.

\code{dmatrixinvt} returns the density at  \code{x}.
}
\description{
Generate random samples from the inverted matrix
variate t distribution or compute densities.
}
\examples{
# an example of drawing from the distribution and computing the density.
A <- rmatrixinvt(n = 2, df = 10, diag(4))
dmatrixinvt(A[, , 1], df = 10, mean = diag(4))
}
\references{
Gupta, Arjun K, and Daya K Nagar. 1999.
Matrix Variate Distributions.
Vol. 104. CRC Press. ISBN:978-1584880462

Dickey, James M. 1967. “Matricvariate Generalizations of the Multivariate t
Distribution and the Inverted Multivariate t
Distribution.” Ann. Math. Statist. 38 (2): 511–18.
\doi{10.1214/aoms/1177698967}
}
\seealso{
\code{\link[=rmatrixnorm]{rmatrixnorm()}}, \code{\link[=rmatrixt]{rmatrixt()}},
and \code{\link[stats:Distributions]{stats::Distributions()}}.
}
