% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_cML-methods.R
\name{cML_estimate_random}
\alias{cML_estimate_random}
\title{Estimate with Regular Likelihood Using Multiple Random Start Points}
\usage{
cML_estimate_random(
  b_exp,
  b_out,
  se_exp,
  se_out,
  K,
  random_start = 0,
  maxit = 100
)
}
\arguments{
\item{b_exp}{Vector of estimated effects for exposure.}

\item{b_out}{Vector or estimated effects for outcome.}

\item{se_exp}{Vector of standard errors for exposure.}

\item{se_out}{Vector of standard errors for outcome.}

\item{K}{Constraint parameter, number of invalid IVs.}

\item{random_start}{Number of random starting points, default is 0.}

\item{maxit}{Maximum number of iteration.}
}
\value{
A list contains: theta is the estimate causal effect,
se is standard error of estimated theta,
l is negative log-likelihood,
r_est is estimated r vector.
}
\description{
Internal function of mr_cML. 
Get estimated theta, se of estimated theta
and negative log-likelihood,
using multiple random starting points.
}
\examples{
cML_estimate_random(b_exp = ldlc,b_out = chdlodds,se_exp = ldlcse,
se_out = chdloddsse, K = 5)
}
