% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pheno_input-function.R
\name{phenoscanner}
\alias{phenoscanner}
\title{PhenoScanner}
\usage{
phenoscanner(
  snpquery = NULL,
  genequery = NULL,
  regionquery = NULL,
  catalogue = "GWAS",
  pvalue = 1e-05,
  proxies = "None",
  r2 = 0.8,
  build = 37
)
}
\arguments{
\item{snpquery}{a vector of SNPs.}

\item{genequery}{a vector of gene names.}

\item{regionquery}{a vector of genomic regions.}

\item{catalogue}{the catalogue to be searched (options: None, GWAS, eQTL, pQTl, mQTL, methQTL).}

\item{pvalue}{the p-value threshold.}

\item{proxies}{the proxies database to be searched (options: None, AFR, AMR, EAS, EUR, SAS).}

\item{r2}{the r2 threshold.}

\item{build}{the genome build (options: 37, 38).}
}
\value{
a list containing a data.frame of association results and a data.frame of SNP/Region/Gene information from PhenoScanner.
}
\description{
The \code{phenoscanner} function queries the PhenoScanner database of genotype-phenotype associations from inside R.
}
\examples{
# SNP
res <- phenoscanner(snpquery="rs10840293")
head(res$results)
res$snps

# Gene
res <- phenoscanner(genequery="SWAP70")
head(res$results)
res$snps

# Region
res <- phenoscanner(regionquery="chr11:9685624-9774538")
head(res$results)
res$regions
}
\author{
PhenoScanner <phenoscanner@gmail.com>
}
