% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertEPARegions.R
\name{convertEPARegions}
\alias{convertEPARegions}
\title{Convert EPA Region shapefiles}
\usage{
convertEPARegions()
}
\value{
Name of the datasetName being created.
}
\description{
Returns a simple features data frame for EPA Regions

The full resolution file will be named "EPA_Regions.rda". In addition,
"_05", _02" and "_01" versions of the file will be created that that are
simplified to 5\%, 2\% and 1\%. Simplified versions will greatly improve the
speed of both searching and plotting.
}
\details{
An EPA region boundary shapefile is converted to a
simple features data frame with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.

The source data is from 2022.
}
\note{
From the source documentation:

This datasetName represents delineated EPA Region boundaries. EPA has ten
regional offices across the country, each of which is responsible for several
states and in some cases, territories or special environmental programs.

This Shared Enterprise Geodata and Services (SEGS)datasetName was created by
U.S. EPA using 2011 TIGER/Line state boundaries from the U.S. Census Bureau.
The core mission of SEGS is to provide a single point of ownership for
geospatial datasetNames that are national in extent and of general use to all
EPA users and to make those datasetNames available through channels that best
meet user needs.
}
\references{
\url{https://hub.arcgis.com/datasets/geoplatform::epa-regions}
}
