% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_addCoreMetadata.R
\name{table_addCoreMetadata}
\alias{table_addCoreMetadata}
\title{Addes missing metadata columns a known location table}
\usage{
table_addCoreMetadata(locationTbl = NULL)
}
\arguments{
\item{locationTbl}{Tibble of known locations. This input tibble need not be a 
standardized "known location" with all required columns. They will be added.}
}
\value{
Tibble with the metadata columns required in a "known locations" table.
}
\description{
An existing table will be amended to guarantee that it includes
the following core metadata columns.

\itemize{
\item{locationID}
\item{locationName}
\item{longitude}
\item{latitude}
\item{elevation}
\item{countryCode}
\item{stateCode}
\item{county}
\item{timezone}
\item{houseNumber}
\item{street}
\item{city}
\item{zip}
}

The \code{longitude} and \code{latitude} columns are required to exist in the
incoming tibble but all others are optional.

If any of these core metadata columns are found, they will be retained.

The \code{locationID} will be generated (anew if already found) from existing
longitude and latitude data.

Other core metadata columns will be filled with \code{NA} values of the 
proper type.

The result is a tibble with all of the core metadata columns. Theses columns
must then be filled in to create a usable "known locations" table.
}
\note{
No check is performed for overlapping locations. The returned tibble
has the structure of a "known locations" table and is a good starting place
investigation. But further work is required to produce a valid table of
"known locations" associated with a specific spatial scale.
}
