% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_getRecordIndex.R
\name{table_getRecordIndex}
\alias{table_getRecordIndex}
\title{Return indexes of known location records}
\usage{
table_getRecordIndex(locationTbl = NULL, locationID = NULL, verbose = TRUE)
}
\arguments{
\item{locationTbl}{Tibble of known locations, Default: NULL}

\item{locationID}{Vector of \code{locationID} strings, Default: NULL}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Vector of \code{locationTbl} row indexes.
}
\description{
Returns a vector of \code{locationTbl} row indexes for the 
locations associated with each \code{locationID}.
}
\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))

# Wenatchee
lon <- -120.325278
lat <- 47.423333

# Get the locationID first
locationID <- table_getLocationID(locationTbl, lon, lat, radius = 5000)

# Now find the row associated with this ID
recordIndex <- table_getRecordIndex(locationTbl, locationID)

str(locationTbl[recordIndex,])
}
