% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logMaddison.R
\name{logMaddison}
\alias{logMaddison}
\title{Select countries and add logged variables}
\usage{
logMaddison(ISO = NULL)
}
\arguments{
\item{ISO}{either NULL to select all the data in \code{MaddisonData} or a
character vector of \code{ISO} codes used in the Maddison project.}
}
\value{
a \code{\link[tibble:tibble]{tibble::tibble}} with 6 columns:
\describe{
\item{ISO}{3-letter ISO code for countries selected}
\item{year}{numeric year in the current era.}
\item{gdppc}{
Gross domestic product per capita adjusted for inflation to 2011
dollars at purchasing power parity.
}
\item{pop}{Population, mid-year (thousands)}
\item{lnGDPpc}{\code{log(gdppc)}}
\item{lnPop}{\code{log(pop)}}
}
}
\description{
\code{logMaddison} returns a \code{\link[tibble:tibble]{tibble::tibble}} of data on selected countries
extracted from \code{MaddisonData}, appending columns \code{lnGDPpc} and \code{lnPop} =
natural logarithms of \code{gdppc} and \code{pop}.
}
\examples{
logMaddison() # all 
logMaddison(c('GBR', 'USA')) # GBR, USA

}
\keyword{manip}
