% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{ParameterGrid}
\alias{ParameterGrid}
\alias{ParameterGrid.param}
\alias{ParameterGrid.list}
\alias{ParameterGrid.parameters}
\title{Tuning Parameters Grid}
\usage{
ParameterGrid(...)

\method{ParameterGrid}{param}(..., size = 3, random = FALSE, length = NULL)

\method{ParameterGrid}{list}(x, size = 3, random = FALSE, length = NULL, ...)

\method{ParameterGrid}{parameters}(x, size = 3, random = FALSE, length = NULL, ...)
}
\arguments{
\item{...}{named \code{param} objects as defined in the \pkg{dials} package.}

\item{size}{single integer or vector of integers whose positions or names
match the given parameters and which specify the number of values to use in
constructing a regular grid if \code{random = FALSE}; ignored otherwise.}

\item{random}{number of unique grid points to sample at random or
\code{FALSE} for all points from a regular grid defined by \code{size}.}

\item{length}{deprecated argument; use \code{size} instead.}

\item{x}{list of named \code{param} objects or a
\code{\link[dials]{parameters}} object.}
}
\value{
\code{ParameterGrid} class object that inherits from
\code{parameters} and \code{Grid}.
}
\description{
Defines a tuning grid from a set of parameters.
}
\examples{
## GBMModel tuning parameters
grid <- ParameterGrid(
  n.trees = dials::trees(),
  interaction.depth = dials::tree_depth(),
  random = 5
)
TunedModel(GBMModel, grid = grid)

}
\seealso{
\code{\link{TunedModel}}
}
