% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MachineShop-package.R
\docType{package}
\name{MachineShop-package}
\alias{MachineShop}
\alias{MachineShop-package}
\title{MachineShop: Machine Learning Models and Tools}
\description{
Meta-package for statistical and machine learning with a unified
    interface for model fitting, prediction, performance assessment, and
    presentation of results.  Approaches for model fitting and prediction of
    numerical, categorical, or censored time-to-event outcomes include
    traditional regression models, regularization methods, tree-based methods,
    support vector machines, neural networks, ensembles, data preprocessing,
    filtering, and model tuning and selection.  Performance metrics are provided
    for model assessment and can be estimated with independent test sets, split
    sampling, cross-validation, or bootstrap resampling.  Resample estimation
    can be executed in parallel for faster processing and nested in cases of
    model tuning and selection.  Modeling results can be summarized with
    descriptive statistics; calibration curves; variable importance; partial
    dependence plots; confusion matrices; and ROC, lift, and other performance
    curves.
}
\details{
The following set of model fitting, prediction, and performance assessment
functions are available for \pkg{MachineShop} \link{models}.

Training:
\tabular{ll}{
  \code{\link{fit}} \tab Model Fitting \cr
  \code{\link{resample}} \tab Resample Estimation of Model Performance \cr
}

Response Values:
\tabular{ll}{
  \code{\link{response}} \tab Observed \cr
  \code{\link{predict}} \tab Predicted \cr
}

Performance Assessment:
\tabular{ll}{
  \code{\link{calibration}} \tab Model Calibration \cr
  \code{\link{confusion}} \tab Confusion Matrix \cr
  \code{\link{dependence}} \tab Parital Dependence \cr
  \code{\link{diff}} \tab Model Performance Differences \cr
  \code{\link{lift}} \tab Lift Curves \cr
  \code{\link{performance} \link{metrics}} \tab Model Performance Metrics \cr
  \code{\link{performance_curve}} \tab Model Performance Curves \cr
  \code{\link{varimp}} \tab Variable Importance \cr
}

Methods for resample estimation include

\tabular{ll}{
  \code{\link{BootControl}} \tab Simple Bootstrap \cr
  \code{\link{BootOptimismControl}} \tab Optimism-Corrected Bootstrap \cr
  \code{\link{CVControl}} \tab Repeated K-Fold Cross-Validation \cr
  \code{\link{CVOptimismControl}} \tab Optimism-Corrected Cross-Validation \cr
  \code{\link{OOBControl}} \tab Out-of-Bootstrap \cr
  \code{\link{SplitControl}} \tab Split Training-Testing \cr
  \code{\link{TrainControl}} \tab Training Resubstitution \cr
}

Graphical and tabular summaries of modeling results can be obtained with

\code{\link{plot}} \cr
\code{\link{print}} \cr
\code{\link{summary}}

Further information on package features is available with

\tabular{ll}{
  \code{\link{metricinfo}} \tab Performance Metric Information \cr
  \code{\link{modelinfo}} \tab Model Information \cr
  \code{\link{settings}} \tab Global Settings \cr
}

Custom metrics and models can be created with the \code{\link{MLMetric}} and
\code{\link{MLModel}} constructors.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://brian-j-smith.github.io/MachineShop/}
  \item Report bugs at \url{https://github.com/brian-j-smith/MachineShop/issues}
}

}
\author{
\strong{Maintainer}: Brian J Smith \email{brian-j-smith@uiowa.edu}

}
