% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunedRecipe.R
\name{TunedRecipe}
\alias{TunedRecipe}
\title{Tuned Recipe}
\usage{
TunedRecipe(x, grid = expand_steps(),
  control = MachineShop::settings("control"), metrics = NULL,
  stat = MachineShop::settings("stat.Tune"),
  cutoff = MachineShop::settings("cutoff"))
}
\arguments{
\item{x}{untrained \code{\link[recipes]{recipe}}.}

\item{grid}{\code{RecipeGrid} containing parameter values at which to
evaluate a recipe, such as those returned by \code{\link{expand_steps}}.}

\item{control}{\link[=controls]{control} function, function name, or call
defining the resampling method to be employed.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.  Recipe
selection is based on the first calculated metric.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metric values for recipe tuning.}

\item{cutoff}{argument passed to the \code{metrics} functions.}
}
\value{
\code{TunedRecipe} class object that inherits from \code{recipe}.
}
\description{
Recipe tuned over a grid of parameter values.
}
\examples{
library(recipes)
library(MASS)

rec <- recipe(medv ~ ., data = Boston) \%>\%
  step_pca(all_numeric(), -all_outcomes(), id = "pca")

grid <- expand_steps(
  pca = list(num_comp = 1:3)
)

fit(TunedRecipe(rec, grid = grid), model = GLMModel)

}
\seealso{
\code{\link{fit}}, \code{\link{resample}}, \code{\link{tune}}
}
