% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{Process simulation method.}
\usage{
sim(object, n, m, theta, burnin = 500)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}.}

\item{n}{Simulation length. (Default: \code{n = 1000})}

\item{m}{Number of simulations. (Default: \code{m = 1})}

\item{theta}{Vector (of size d) or matrix (of size M x d) of parameter estimates.}

\item{burnin}{(integer >= 0) Burnin period discarded (first simulation draws). (Default: \code{burnin = 500})}
}
\value{
A list of class \code{MSGARCH_SIM} containing two components.
\itemize{
\item \code{draws}: Matrix (of size M x n) of simulated draws.
\item \code{state}: Matrix (of size M x n) of simulated states.
}
 The \code{MSGARCH_SIM} class contains the \code{plot} method.
}
\description{
Method simulating a \code{MSGARCH} process.
}
\details{
If a matrix of parameter estimates is given, each parameter estimates is evaluated individually and \code{m = M}.  The difference between \code{\link{sim}} and \code{\link{simahead}} is that
\code{\link{sim}} starts the simulation a t = 0 creating an entire new process while  \code{\link{simahead}} starts the simulation at t = T + 1
 taking in consideration all the information available in the original time serie \code{y}.
}
\examples{
# create model specification
spec = MSGARCH::create.spec() 

# generate process
set.seed(123)
sim = MSGARCH::sim(object = spec, n = 1000, m = 1, theta = spec$theta0, burnin = 500)

plot(sim)
}

