% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes.R
\name{fit.bayes}
\alias{fit.bayes}
\title{Bayesian estimation.}
\usage{
fit.bayes(spec, y, ctr = list())
}
\arguments{
\item{spec}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}.}

\item{y}{Vector (of size T) of observations.}

\item{ctr}{A list of control parameters. \cr
The control parameters have three components:
\itemize{
\item \code{N.burn} (integer >= 0): Number of discarded draws. (Default: \code{N.burn = 5000})
\item \code{N.mcmc} (integer > 0) : Number of draws. (Default: \code{N.mcmc = 10000})
\item \code{N.thin} (integer > 0) : Thinning factor (every \code{N.thin} draws are kept). (Default: \code{N.thin = 10})
\item \code{theta0} : Starting value for the chain (if empty the specification default value are used).
\item \code{do.enhance.theta0} : Boolean indicating if the default parameters value are enhance using \code{y} variance. (Default: \code{do.enhance.theta0 = FALSE})
}}
}
\value{
A list of class \code{MSGARCH_BAY_FIT} containing four components:
\itemize{
\item \code{theta} : The MCMC chain (matrix from the \R package \code{coda} (Plummer et al., 2006) of size \code{N.mcmc / N.thin}).
\item \code{accept} : Acceptation rate of the sampler.
\item \code{y} :  Vector (of size T) of observations.
\item \code{spec} :  Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}.
}
The \code{MSGARCH_BAY_FIT} contains these methods:
\itemize{
\item \code{\link{AIC}} : Compute Akaike information criterion (AIC).
\item \code{\link{BIC}} : Compute Bayesian information criterion (BIC).
\item \code{\link{DIC}} : Compute Deviance Information Criterion (DIC).
\item \code{\link{ht}}  : Conditional volatility in each regime.
\item \code{\link{kernel}} : Kernel method.
\item \code{\link{unc.vol}} : Unconditional volatility in each regime.
\item \code{\link{pred}} : Predictive method.
\item \code{\link{pit}} : Probability Integral Transform.
\item \code{\link{risk}} : Value-at-Risk And Expected-Shortfall methods.
\item \code{\link{simahead}} : Step ahead simulation method.
\item \code{\link{sim}} : Simulation method.
\item \code{\link{pdf}} : Probability density function.
\item \code{\link{cdf}} : Cumulative function.
\item \code{\link{Pstate}} : State probabilities filtering method.
\item \code{summary} : Summary of the fit.
}
}
\description{
Method that performs Bayesian estimation of a \code{MSGARCH_SPEC} object on a set of observations.
}
\details{
The total number of draws is equal to \code{N.mcmc / N.thin}.
The Bayesian estimation uses the \R package \code{adaptMCMC} (Andreas, 2012) which  
implements the adaptive sampler of Vihola (2012). The argument \code{do.enhance.theta0}
 uses the volatilities of rolling windows of \code{y} and adjust the default parameter of
 the specification so that the unconditional volatility of each regime
 is set to different quantiles of the volatilities of the rolling windows of \code{y}.
}
\examples{
\dontrun{
# load data
data("sp500")

# create model specification
spec = MSGARCH::create.spec() 

# fit the model on the data with Bayesian estimation
set.seed(123)
fit = MSGARCH::fit.bayes(spec = spec, y = sp500, 
                         ctr = list(N.burn = 10000, N.mcmc = 10000, N.thin = 1))
}                          
}
\references{
Andreas, S. (2012). \code{adaptMCMC}: Implementation of a Generic Adaptive Monte Carlo Markov Chain Sampler. \url{https://cran.r-project.org/package=adaptMCMC}.

Metropolis, N.; Rosenbluth, A. W.; Rosenbluth, M. N.; Teller, A. H. & Teller, E. (1953). Equation of State Calculations by Fast Computing Machines. \emph{Journal of Chemical Physics}, 21, pp. 1087-1092.

Plummer, M. Best, N. Cowles, K. & Vines, K. (2006). \code{CODA}: Convergence Diagnosis and Output Analysis for MCMC. \emph{R News}, 6, pp.7-11. \url{https://cran.r-project.org/package=coda}.

Vihola, M. (2012). Robust Adaptive Metropolis Algorithm with Coerced Acceptance Rate. \emph{Statistics and Computing}, 22, pp. 997-1008.
}

