% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_neighborhood.R
\name{define_neighborhood}
\alias{define_neighborhood}
\title{Calculate neighborhood relations}
\usage{
define_neighborhood(neighbors, v.matrix, iter)
}
\arguments{
\item{neighbors}{List containing the decomposition method parameters.
This list must contain the following key-value pairs:
\itemize{
\item \code{neighbors$name}, type of neighborhood to use. The following types
are currently available:
\itemize{
\item \code{neighbors$name = "lambda"}: defines the neighborhood using
the distance matrix for the weight vectors. The calculation is
performed only once for the entire run.
\item \code{neighbors$name = "x"}: defines the neighborhood using
the distance matrix for the incumbent solution associated with
each subproblem. In this case the calculation is performed at
each iteration.
}
\item \code{neighbors$T}: Neighborhood size. The value of \code{neighbors$T}
must be smaller than the number of subproblems.
\item \code{neighbors$delta.p}: Probability of sampling from the neighborhood
when performing variation. Must be a scalar value between 0 and 1.
}}

\item{v.matrix}{matrix of vectors to be used for defining the neighborhoods.}

\item{iter}{iteration counter of the MOEA/D}
}
\value{
List containing the matrix of selection probabilities (\code{P}) and
the matrix of neighborhoods (\code{B}).
}
\description{
Calculates neighborhood relations for the MOEADr package
}
\details{
This routine calculates the neighborhood relations for the MOEA/D.

\strong{Warning}: this routine may access (but not directly modify) variables
from the calling environment.
}
\section{References}{

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

