% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minorFuns.R
\name{minorFuns}
\alias{minorFuns}
\alias{search4map}
\title{Minor MODIS Package Functions}
\usage{
search4map(pattern = "", database = "worldHires", plot = FALSE)
}
\arguments{
\item{pattern}{Regular expression passed to \code{\link[=grep]{grep()}}.}

\item{database}{\code{character}. Defaults to \code{"worldHires"}, see \code{\link[maps:map]{maps::map()}}
for available options.}

\item{plot}{\code{logical}, defaults to \code{FALSE}. If \code{TRUE}, search results are
displayed.}
}
\value{
A \code{list} of length 2. The first entry is the call to create the given
map, whereas the second entry represents the names of areas within the
search.
}
\description{
Compendium of minor \strong{MODIS} package-related functions.
}
\section{Functions}{
\itemize{
\item \code{search4map()}: Simplifies search for \strong{mapdata}-based extents

}}
\examples{
\donttest{
search4map()

search4map(pattern="USA",plot=TRUE)
search4map(database="state",plot=TRUE)

search4map(database="italy",pattern="Bolz",plot=TRUE)

search4map(pattern="Sicily",plot=TRUE)
}

}
\seealso{
\code{\link[=getTile]{getTile()}}, \code{\link[maps:map]{maps::map()}}, \code{\link[=grep]{grep()}}.
}
\author{
Matteo Mattiuzzi
}
